/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.definitions.AEItems;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.parts.PartModel;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.IOBusPart;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.ConfigInventory;
import com.glodblock.github.extendedae.config.EPPConfig;
import com.glodblock.github.extendedae.container.ContainerPreciseExportBus;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;

public class PartPreciseExportBus
extends ExportBusPart {
    public static List<ResourceLocation> MODELS = Arrays.asList(new ResourceLocation("expatternprovider", "part/precise_export_bus_base"), new ResourceLocation("ae2", "part/export_bus_on"), new ResourceLocation("ae2", "part/export_bus_off"), new ResourceLocation("ae2", "part/export_bus_has_channel"));
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(2)});
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(1)});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(3)});
    private ConfigInventory config;

    public PartPreciseExportBus(IPartItem<?> partItem) {
        super(partItem);
    }

    public void readFromNBT(CompoundTag extra) {
        super.readFromNBT(extra);
        this.config.readFromChildTag(extra, "config2");
    }

    public void writeToNBT(CompoundTag extra) {
        super.writeToNBT(extra);
        this.config.writeToChildTag(extra, "config2");
    }

    public ConfigInventory getConfig() {
        if (this.config == null) {
            this.config = new PreciseInventory(this);
        }
        return this.config;
    }

    private boolean craftOnly() {
        return this.isCraftingEnabled() && this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    private boolean isCraftingEnabled() {
        return this.isUpgradedWith((ItemLike)AEItems.CRAFTING_CARD);
    }

    private void attemptCrafting(StackTransferContext context, ICraftingService cg, int slotToExport, AEKey what, long targetAmount) {
        long amount = this.getExportStrategy().push(what, targetAmount, Actionable.SIMULATE);
        if (amount == targetAmount) {
            this.requestCrafting(cg, slotToExport, what, amount);
            context.reduceOperationsRemaining(Math.max(1L, amount / (long)what.getAmountPerOperation()));
        }
    }

    protected boolean doBusWork(IGrid grid) {
        int x;
        IStorageService storageService = grid.getStorageService();
        ICraftingService cg = grid.getCraftingService();
        SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
        StackTransferContext context = Ae2Reflect.getExportContext(this, storageService, grid.getEnergyService());
        for (x = 0; x < this.availableSlots() && context.hasOperationsLeft(); ++x) {
            long realSend;
            int slotToExport = this.getStartingSlot(schedulingMode, x);
            GenericStack stack = this.getConfig().getStack(slotToExport);
            if (stack == null) continue;
            AEKey what = stack.what();
            long amount = stack.amount();
            int transferFactor = what.getAmountPerOperation();
            if (this.craftOnly()) {
                this.attemptCrafting(context, cg, slotToExport, what, amount);
                continue;
            }
            long before = context.getOperationsRemaining();
            if (before < Math.max(1L, amount / (long)transferFactor)) break;
            long ceil = PartPreciseExportBus.simulateExtract(context, what, before * (long)transferFactor) / amount * amount;
            long canHold = this.getExportStrategy().push(what, ceil, Actionable.SIMULATE) / amount * amount;
            if (canHold > 0L && (realSend = this.getExportStrategy().transfer(context, what, canHold)) > 0L) {
                context.reduceOperationsRemaining(Math.max(1L, canHold / (long)transferFactor));
            }
            if (before != (long)context.getOperationsRemaining() || !this.isCraftingEnabled()) continue;
            this.attemptCrafting(context, cg, slotToExport, what, amount);
        }
        if (context.hasDoneWork()) {
            this.updateSchedulingMode(schedulingMode, x);
        }
        return context.hasDoneWork();
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    protected int getOperationsPerTick() {
        return super.getOperationsPerTick() * EPPConfig.busSpeed;
    }

    protected MenuType<?> getMenuType() {
        return ContainerPreciseExportBus.TYPE;
    }

    private static long simulateExtract(StackTransferContext context, AEKey what, long amount) {
        IStorageService inv = context.getInternalStorage();
        return StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)amount, (IActionSource)context.getActionSource(), (Actionable)Actionable.SIMULATE);
    }

    static class PreciseInventory
    extends ConfigInventory {
        protected PreciseInventory(PartPreciseExportBus host) {
            super(StackWorldBehaviors.hasExportStrategyFilter(), GenericStackInv.Mode.CONFIG_STACKS, 63, () -> Ae2Reflect.updatePartState((IOBusPart)host), true);
        }

        public long getMaxAmount(AEKey key) {
            return 64L * (long)key.getAmountPerUnit();
        }
    }
}

