/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.util.inv.AppEngInternalInventory;
import com.glodblock.github.extendedae.client.button.ActionEPPButton;
import com.glodblock.github.extendedae.client.button.CycleEPPButton;
import com.glodblock.github.extendedae.client.gui.widget.AssemblerMatrixSlot;
import com.glodblock.github.extendedae.container.ContainerAssemblerMatrix;
import com.glodblock.github.extendedae.network.EPPNetworkHandler;
import com.glodblock.github.extendedae.util.FCUtil;
import com.glodblock.github.glodium.network.packet.CGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GuiAssemblerMatrix
extends AEBaseScreen<ContainerAssemblerMatrix>
implements IActionHolder {
    private static final int ROW_HEIGHT = 18;
    private static final int GUI_PADDING_X = 8;
    private static final int SLOT_SIZE = 18;
    private static final ResourceLocation BG = AppEng.makeId((String)"textures/guis/assembler_matrix.png");
    private static final Rect2i EMPTY_ROW1 = new Rect2i(0, 199, 162, 18);
    private static final Rect2i EMPTY_ROW2 = new Rect2i(0, 217, 162, 18);
    private static final Rect2i EMPTY_ROW3 = new Rect2i(0, 235, 162, 18);
    private final Map<String, Consumer<Paras>> actions = this.createHolder();
    private final Scrollbar scrollbar;
    private final Long2ReferenceMap<PatternInfo> infos = new Long2ReferenceOpenHashMap();
    private final Set<ItemStack> matchedStack = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack o) {
            return o.m_41720_().hashCode() ^ (o.m_41782_() ? o.m_41783_().hashCode() : -1);
        }

        public boolean equals(ItemStack a, ItemStack b) {
            return a == b || a != null && b != null && ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
        }
    });
    private final ArrayList<PatternRow> rows = new ArrayList();
    private final AETextField searchField;
    private int runningThreads = 0;
    private final CycleEPPButton patternShowBtn = new CycleEPPButton();

    public GuiAssemblerMatrix(ContainerAssemblerMatrix menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.scrollbar = this.widgets.addScrollBar("scrollbar");
        this.searchField = this.widgets.addTextField("search");
        this.searchField.m_94151_(str -> this.refreshList());
        this.searchField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
        this.searchField.setTooltipMessage(Collections.singletonList(Component.m_237115_((String)"gui.expatternprovider.assembler_matrix.tooltip")));
        this.actions.put("running_update", o -> {
            this.runningThreads = (Integer)o.get(0);
        });
        this.actions.put("pattern_mode_update", o -> this.patternShowBtn.setState((Integer)o.get(0)));
        ActionEPPButton cancel = new ActionEPPButton(b -> EPPNetworkHandler.INSTANCE.sendToServer((IMessage)new CGenericPacket("cancel")), Icon.CLEAR);
        cancel.m_93666_((Component)Component.m_237115_((String)"gui.expatternprovider.assembler_matrix.cancel"));
        this.patternShowBtn.addActionPair(Icon.PATTERN_ACCESS_SHOW, (Component)GuiText.PatternAccessTerminalHint.text(), b -> EPPNetworkHandler.INSTANCE.sendToServer((IMessage)new CGenericPacket("pattern_mode", new Object[]{YesNo.NO.name()})));
        this.patternShowBtn.addActionPair(Icon.PATTERN_ACCESS_HIDE, (Component)GuiText.PatternAccessTerminalHint.text(), b -> EPPNetworkHandler.INSTANCE.sendToServer((IMessage)new CGenericPacket("pattern_mode", new Object[]{YesNo.YES.name()})));
        this.addToLeftToolbar((Button)cancel);
        this.addToLeftToolbar((Button)this.patternShowBtn);
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_264313_((GuiEventListener)this.searchField);
        this.resetScrollbar();
    }

    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchField.m_5953_(xCoord, yCoord)) {
            this.searchField.m_94144_("");
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((ContainerAssemblerMatrix)this.f_97732_).f_38839_.removeIf(slot -> slot instanceof AssemblerMatrixSlot);
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < 4; ++i) {
            if (scrollLevel + i >= this.rows.size()) continue;
            PatternRow row = this.rows.get(scrollLevel + i);
            for (int col = 0; col < row.slots; ++col) {
                AssemblerMatrixSlot slot2 = new AssemblerMatrixSlot(row.inventory, col, row.offset, row.id, col * 18 + 8, (i + 1) * 18 + 13);
                ((ContainerAssemblerMatrix)this.f_97732_).f_38839_.add((Object)slot2);
                if (this.searchField.m_94155_().isEmpty()) continue;
                if (this.matchedStack.contains(slot2.m_7993_())) {
                    this.fillRect(guiGraphics, new Rect2i(slot2.f_40220_, slot2.f_40221_, 16, 16), -1979646208);
                    continue;
                }
                this.fillRect(guiGraphics, new Rect2i(slot2.f_40220_, slot2.f_40221_, 16, 16), 0x6A000000);
            }
        }
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.expatternprovider.assembler_matrix.threads", (Object[])new Object[]{this.runningThreads}), 80, 19, textColor, false);
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        int size;
        super.drawBG(guiGraphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        if (size < 4) {
            for (size = this.rows.size(); size < 4; ++size) {
                if (size == 0) {
                    this.blit(guiGraphics, offsetX + 8 - 1, offsetY + 18 * size + 30, EMPTY_ROW1);
                    continue;
                }
                if (size == 3) {
                    this.blit(guiGraphics, offsetX + 8 - 1, offsetY + 18 * size + 30, EMPTY_ROW3);
                    continue;
                }
                this.blit(guiGraphics, offsetX + 8 - 1, offsetY + 18 * size + 30, EMPTY_ROW2);
            }
        }
    }

    protected void m_6597_(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof AssemblerMatrixSlot) {
            AssemblerMatrixSlot machineSlot = (AssemblerMatrixSlot)slot;
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!this.getPlayer().m_150110_().f_35937_) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.getActuallySlot(), machineSlot.getID());
                NetworkHandler.instance().sendToServer((BasePacket)p);
            }
            return;
        }
        super.m_6597_(slot, slotIdx, mouseButton, clickType);
    }

    private void blit(GuiGraphics guiGraphics, int offsetX, int offsetY, Rect2i srcRect) {
        guiGraphics.m_280218_(BG, offsetX, offsetY, srcRect.m_110085_(), srcRect.m_110086_(), srcRect.m_110090_(), srcRect.m_110091_());
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(70);
        this.scrollbar.setRange(0, this.rows.size() - 4, 2);
    }

    public void receiveUpdate(long id, Int2ObjectMap<ItemStack> updateMap) {
        PatternInfo info = (PatternInfo)this.infos.computeIfAbsent(id, PatternInfo::new);
        for (Int2ObjectMap.Entry entry : updateMap.int2ObjectEntrySet()) {
            PatternRow row = info.getRowBySlot(entry.getIntKey());
            row.setItemByInvSlot(entry.getIntKey(), (ItemStack)entry.getValue());
        }
        this.refreshList();
    }

    private void refreshList() {
        this.rows.clear();
        this.matchedStack.clear();
        for (Long2ReferenceMap.Entry entry : this.infos.long2ReferenceEntrySet()) {
            PatternInfo info = (PatternInfo)entry.getValue();
            for (PatternRow row : info.internalRows) {
                if (!this.filterRows(row)) continue;
                this.rows.add(row);
            }
        }
        this.resetScrollbar();
    }

    private boolean filterRows(PatternRow row) {
        String filter = this.searchField.m_94155_();
        if (filter.isBlank()) {
            return true;
        }
        List<String> token = FCUtil.tokenize(filter);
        boolean anyMatch = false;
        for (ItemStack stack : row.inventory) {
            if (!this.itemStackMatchesSearchTerm(stack, token)) continue;
            anyMatch = true;
        }
        return anyMatch;
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, List<String> searchTokens) {
        List<String> nameTokens;
        IPatternDetails result = null;
        if (itemStack.m_41720_() instanceof EncodedPatternItem) {
            result = PatternDetailsHelper.decodePattern((ItemStack)itemStack, (Level)((ContainerAssemblerMatrix)this.f_97732_).getPlayer().m_9236_());
        }
        if (result == null) {
            return false;
        }
        for (GenericStack genericStack : result.getOutputs()) {
            if (genericStack == null || !FCUtil.compareTokens(searchTokens, nameTokens = FCUtil.tokenize(genericStack.what().getDisplayName().getString()))) continue;
            this.matchedStack.add(itemStack);
            return true;
        }
        for (GenericStack genericStack : result.getInputs()) {
            if (genericStack == null || !FCUtil.compareTokens(searchTokens, nameTokens = FCUtil.tokenize(genericStack.getPossibleInputs()[0].what().getDisplayName().getString()))) continue;
            this.matchedStack.add(itemStack);
            return true;
        }
        return false;
    }

    @NotNull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.actions;
    }

    private static class PatternRow {
        private final AppEngInternalInventory inventory;
        private final long id;
        private final int offset;
        private final int slots;

        PatternRow(long patternID, int offset, int slots) {
            this.id = patternID;
            this.offset = offset;
            this.slots = slots;
            this.inventory = new AppEngInternalInventory(slots);
        }

        void setItemByInvSlot(int slot, ItemStack stack) {
            this.inventory.setItemDirect(slot - this.offset, stack);
        }
    }

    private static class PatternInfo {
        private final List<PatternRow> internalRows = new ArrayList<PatternRow>();

        PatternInfo(long id) {
            int left = 36;
            int offset = 0;
            do {
                this.internalRows.add(new PatternRow(id, offset, Math.min(left, 9)));
                offset += 9;
            } while ((left -= 9) > 0);
        }

        PatternRow getRowBySlot(int slot) {
            return this.internalRows.get(slot / 9);
        }
    }
}

