/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import java.util.List;
import java.util.Random;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;

public final class WeightedPicker {
    private WeightedPicker() {
    }

    @Nullable
    public static <T> T pickRandom(List<T> items, ToIntFunction<T> weightFunc) {
        return WeightedPicker.pickRandom(items, weightFunc, new Random());
    }

    @Nullable
    public static <T> T pickRandom(@Nullable List<T> items, ToIntFunction<T> weightFunc, Random rand) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        int total = 0;
        for (T t : items) {
            int w = Math.max(0, weightFunc.applyAsInt(t));
            total += w;
        }
        if ((long)total <= 0L) {
            return items.get(rand.nextInt(items.size()));
        }
        int pick = rand.nextInt(total);
        int acc = 0;
        for (T t : items) {
            int w = Math.max(0, weightFunc.applyAsInt(t));
            if (pick >= (acc += w)) continue;
            return t;
        }
        return items.get(items.size() - 1);
    }

    @Nullable
    public static <T> T pickDeterministic(List<T> items, ToIntFunction<T> weightFunc, long seed) {
        return WeightedPicker.pickRandom(items, weightFunc, new Random(seed));
    }
}

