/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public final class TaskEquipUtil {
    private TaskEquipUtil() {
    }

    public static boolean tryEquipFromBackpack(EntityMaid maid, Predicate<ItemStack> predicate) {
        if (predicate.test(maid.m_21205_())) {
            return true;
        }
        RangedWrapper backpack = maid.getAvailableBackpackInv();
        int slot = ItemsUtil.findStackSlot((IItemHandler)backpack, predicate);
        if (slot >= 0) {
            int count = backpack.getStackInSlot(slot).m_41613_();
            ItemStack output = backpack.extractItem(slot, count, false);
            if (!maid.m_21205_().m_41619_()) {
                ItemStack mainhand = maid.m_21205_();
                backpack.setStackInSlot(slot, mainhand);
            }
            maid.m_21008_(InteractionHand.MAIN_HAND, output);
            return true;
        }
        return false;
    }

    public static boolean putMainHandBack(EntityMaid maid) {
        if (maid.m_21205_().m_41619_()) {
            return false;
        }
        RangedWrapper backpack = maid.getAvailableBackpackInv();
        ItemStack mainHandItem = maid.m_21205_();
        for (int i = 0; i < backpack.getSlots(); ++i) {
            ItemStack stackInSlot = backpack.getStackInSlot(i);
            if (!stackInSlot.m_41619_()) continue;
            backpack.setStackInSlot(i, mainHandItem);
            maid.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            return true;
        }
        return false;
    }
}

