/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public final class JERIUtil {
    public static void recipeWarp(List<AltarRecipe> altarRecipes, AltarRecipeMaker maker) {
        for (AltarRecipe altarRecipe : altarRecipes) {
            String langKey;
            ResourceLocation recipeId = altarRecipe.m_6423_();
            ItemStack output = altarRecipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
            if (!altarRecipe.isItemCraft()) {
                output = ((Item)InitItems.ENTITY_PLACEHOLDER.get()).m_7968_();
                ItemEntityPlaceholder.setRecipeId(output, altarRecipe.m_6423_());
            }
            String namespace = recipeId.m_135827_().toLowerCase(Locale.US);
            if (altarRecipe.isItemCraft()) {
                langKey = String.format("jei.%s.altar_craft.%s.result", namespace, "item_craft");
            } else {
                Path path = Paths.get(recipeId.m_135815_().toLowerCase(Locale.US), new String[0]);
                langKey = String.format("jei.%s.altar_craft.%s.result", namespace, path.getFileName());
            }
            maker.accept(recipeId, altarRecipe.m_7527_(), output, altarRecipe.getPowerCost(), langKey);
        }
    }

    public static interface AltarRecipeMaker {
        public void accept(ResourceLocation var1, NonNullList<Ingredient> var2, ItemStack var3, float var4, String var5);
    }
}

