/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public final class GetJarResources {
    private GetJarResources() {
    }

    public static void copyTouhouLittleMaidFile(String filePath, Path destPath, String fileName) {
        URL url = TouhouLittleMaid.class.getResource(filePath);
        try {
            if (url != null) {
                FileUtils.copyURLToFile((URL)url, (File)destPath.resolve(fileName).toFile());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static InputStream readTouhouLittleMaidFile(String filePath) {
        URL url = TouhouLittleMaid.class.getResource(filePath);
        try {
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void copyFolder(String sourcePath, Path targetPath) throws IOException, URISyntaxException {
        URL url = TouhouLittleMaid.class.getResource(sourcePath);
        if (url == null) {
            return;
        }
        URI uri = url.toURI();
        Path sourceFolderPath = Paths.get(uri);
        try (Stream<Path> stream = Files.walk(sourceFolderPath, Integer.MAX_VALUE, new FileVisitOption[0]);){
            stream.forEach(source -> {
                Path relativePath = sourceFolderPath.relativize((Path)source);
                String relativePathString = relativePath.toString().replace('\\', '/');
                Path target = targetPath.resolve(relativePathString);
                try {
                    if (Files.isDirectory(source, new LinkOption[0])) {
                        Files.createDirectories(target, new FileAttribute[0]);
                    } else {
                        Path parentDir = target.getParent();
                        if (parentDir != null && !Files.isDirectory(parentDir, new LinkOption[0])) {
                            Files.createDirectories(parentDir, new FileAttribute[0]);
                        }
                        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    TouhouLittleMaid.LOGGER.error("Failed to copy file from {} to target: {}", source, (Object)e.getMessage());
                }
                catch (Exception e) {
                    TouhouLittleMaid.LOGGER.error("Unexpected error during file copy: {}", (Object)e.getMessage());
                }
            });
        }
    }
}

