/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import java.util.concurrent.LinkedBlockingDeque;
import org.jetbrains.annotations.Nullable;

public class CappedQueue<E> {
    private final LinkedBlockingDeque<E> deque;

    public CappedQueue(int maxSize) {
        this.deque = new LinkedBlockingDeque(maxSize);
    }

    public void add(E element) {
        if (!this.deque.offerFirst(element)) {
            this.deque.pollLast();
            this.deque.offerFirst(element);
        }
    }

    @Nullable
    public E remove() {
        return this.deque.pollFirst();
    }

    @Nullable
    public E peek() {
        return this.deque.peekFirst();
    }

    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public int size() {
        return this.deque.size();
    }

    public LinkedBlockingDeque<E> getDeque() {
        return this.deque;
    }
}

