/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameEntityBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.GomokuCodec;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityGomoku
extends TileEntityJoy
implements IBoardGameEntityBlock {
    public static final BlockEntityType<TileEntityGomoku> TYPE = BlockEntityType.Builder.m_155273_(TileEntityGomoku::new, (Block[])new Block[]{(Block)InitBlocks.GOMOKU.get()}).m_58966_(null);
    private static final String CHESS_DATA = "ChessData";
    private static final String STATUE = "Statue";
    private static final String PLAYER_TURN = "PlayerTurn";
    private static final String CHESS_COUNTER = "ChessCounter";
    private static final String LATEST_CHESS_POINT = "LatestChessPoint";
    private int[][] chessData = new int[15][15];
    private int statue = Statue.IN_PROGRESS.ordinal();
    private boolean playerTurn = true;
    private int chessCounter = 0;
    private Point latestChessPoint = Point.NULL;

    public TileEntityGomoku(BlockPos pos, BlockState blockState) {
        super(TYPE, pos, blockState);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        ListTag listTag = new ListTag();
        for (int[] chessRow : this.chessData) {
            listTag.add((Object)new IntArrayTag(chessRow));
        }
        this.getPersistentData().m_128365_(CHESS_DATA, (Tag)listTag);
        this.getPersistentData().m_128405_(STATUE, this.statue);
        this.getPersistentData().m_128379_(PLAYER_TURN, this.playerTurn);
        this.getPersistentData().m_128405_(CHESS_COUNTER, this.chessCounter);
        this.getPersistentData().m_128365_(LATEST_CHESS_POINT, (Tag)Point.toTag(this.latestChessPoint));
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ListTag listTag = this.getPersistentData().m_128437_(CHESS_DATA, 11);
        for (int i = 0; i < listTag.size(); ++i) {
            int[] intArray = listTag.m_128767_(i);
            this.chessData[i] = intArray;
        }
        this.statue = this.getPersistentData().m_128451_(STATUE);
        this.playerTurn = this.getPersistentData().m_128471_(PLAYER_TURN);
        this.chessCounter = this.getPersistentData().m_128451_(CHESS_COUNTER);
        this.latestChessPoint = Point.fromTag(this.getPersistentData().m_128469_(LATEST_CHESS_POINT));
    }

    public void reset() {
        this.chessData = new int[15][15];
        this.statue = Statue.IN_PROGRESS.ordinal();
        this.playerTurn = true;
        this.chessCounter = 0;
        this.latestChessPoint = Point.NULL;
    }

    public int[][] getChessData() {
        return this.chessData;
    }

    public void setChessData(int x, int y, int type) {
        this.chessData[x][y] = type;
        this.latestChessPoint = new Point(x, y, type);
        ++this.chessCounter;
    }

    public void clickWithDebug() {
        int[][] drawBoard = new int[15][15];
        for (int x = 0; x < 15; ++x) {
            boolean blackFirst = x / 2 % 2 == 0;
            for (int y = 0; y < 15; ++y) {
                drawBoard[x][y] = x == 14 && 12 <= y ? 0 : (blackFirst ? (y % 2 == 0 ? 1 : 2) : (y % 2 == 0 ? 2 : 1));
            }
        }
        this.chessData = drawBoard;
        this.latestChessPoint = new Point(14, 10, 2);
        this.chessCounter = 222;
        this.statue = Statue.IN_PROGRESS.ordinal();
        this.playerTurn = true;
    }

    public boolean isPlayerTurn() {
        return this.playerTurn;
    }

    public void setPlayerTurn(boolean playerTurn) {
        this.playerTurn = playerTurn;
    }

    public void setStatue(Statue statue) {
        this.statue = statue.ordinal();
    }

    public Statue getStatue() {
        return Statue.values()[Mth.m_14045_((int)this.statue, (int)0, (int)(Statue.values().length - 1))];
    }

    public int getChessCounter() {
        return this.chessCounter;
    }

    public Point getLatestChessPoint() {
        return this.latestChessPoint;
    }

    public GomokuCodec.StateData getStateData() {
        return new GomokuCodec.StateData(this.chessData, this.chessCounter, this.latestChessPoint);
    }

    public void setStateData(GomokuCodec.StateData stateData) {
        this.chessData = stateData.board();
        this.chessCounter = stateData.turnCount();
        this.latestChessPoint = stateData.latestPoint();
        this.refresh();
    }
}

