/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSystemServices;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public class TTSSystemAudioToClientMessage {
    private final String siteName;
    private final String chatText;
    private final TTSConfig config;
    private final TTSSystemServices services;

    public TTSSystemAudioToClientMessage(String siteName, String chatText, TTSConfig config, TTSSystemServices services) {
        this.siteName = siteName;
        this.chatText = chatText;
        this.config = config;
        this.services = services;
    }

    public static void encode(TTSSystemAudioToClientMessage message, FriendlyByteBuf buf) {
        buf.m_130070_(message.siteName);
        message.services.writeToNetwork(message.chatText, message.config, buf);
    }

    @Nullable
    public static TTSSystemAudioToClientMessage decode(FriendlyByteBuf buf) {
        String siteName = buf.m_130277_();
        TTSSite ttsSite = AvailableSites.getTTSSite(siteName);
        TTSClient tTSClient = ttsSite.client();
        if (tTSClient instanceof TTSSystemServices) {
            TTSSystemServices services = (TTSSystemServices)((Object)tTSClient);
            Pair<String, TTSConfig> pair = services.readFromNetwork(buf);
            return new TTSSystemAudioToClientMessage(siteName, (String)pair.getLeft(), (TTSConfig)pair.getRight(), services);
        }
        return null;
    }

    public static void handle(@Nullable TTSSystemAudioToClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient() && message != null) {
            context.enqueueWork(() -> TTSSystemAudioToClientMessage.onHandle(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(TTSSystemAudioToClientMessage message) {
        TTSSite ttsSite = AvailableSites.getTTSSite(message.siteName);
        if (ttsSite == null || !ttsSite.enabled()) {
            return;
        }
        ttsSite.client().play(message.chatText, message.config, null);
    }
}

