/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SyncBaubleMessage {
    private final boolean isFull;
    private final int entityId;
    private final Int2ObjectSortedMap<ItemStack> baubles;

    public static SyncBaubleMessage fullSync(int entityId, Int2ObjectSortedMap<ItemStack> baubles) {
        return new SyncBaubleMessage(true, entityId, baubles);
    }

    public static SyncBaubleMessage partialSync(int entityId, int slot, ItemStack stack) {
        Int2ObjectRBTreeMap baubles = new Int2ObjectRBTreeMap();
        baubles.put(slot, (Object)stack);
        return new SyncBaubleMessage(false, entityId, (Int2ObjectSortedMap<ItemStack>)baubles);
    }

    public static SyncBaubleMessage partialDel(int entityId, int slot) {
        Int2ObjectRBTreeMap baubles = new Int2ObjectRBTreeMap();
        baubles.put(slot, (Object)ItemStack.f_41583_);
        return new SyncBaubleMessage(false, entityId, (Int2ObjectSortedMap<ItemStack>)baubles);
    }

    private SyncBaubleMessage(boolean isFull, int entityId, Int2ObjectSortedMap<ItemStack> baubles) {
        this.isFull = isFull;
        this.entityId = entityId;
        this.baubles = baubles;
    }

    public static void encode(SyncBaubleMessage message, FriendlyByteBuf buf) {
        buf.writeBoolean(message.isFull);
        buf.m_130130_(message.entityId);
        buf.m_130130_(message.baubles.size());
        message.baubles.forEach((slot, stack) -> {
            buf.m_130130_(slot.intValue());
            buf.m_130055_(stack);
        });
    }

    public static SyncBaubleMessage decode(FriendlyByteBuf buf) {
        boolean action = buf.readBoolean();
        int entityId = buf.m_130242_();
        Int2ObjectRBTreeMap baubles = new Int2ObjectRBTreeMap();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            int slot = buf.m_130242_();
            ItemStack stack = buf.m_130267_();
            baubles.put(slot, (Object)stack);
        }
        return new SyncBaubleMessage(action, entityId, (Int2ObjectSortedMap<ItemStack>)baubles);
    }

    public static void handle(SyncBaubleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> SyncBaubleMessage.handleClient(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(SyncBaubleMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity entity = mc.f_91073_.m_6815_(message.entityId);
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            BaubleItemHandler maidBauble = maid.getMaidBauble();
            if (message.isFull) {
                maidBauble.clearAll();
            }
            message.baubles.forEach((arg_0, arg_1) -> ((BaubleItemHandler)maidBauble).setStackInSlot(arg_0, arg_1));
        }
    }
}

