/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class OpenPlayerInventoryMessage {
    public static final int OPEN_PLAYER_INVENTORY = 0;
    private final int action;

    public OpenPlayerInventoryMessage(int action) {
        this.action = action;
    }

    public static OpenPlayerInventoryMessage decode(FriendlyByteBuf buf) {
        int action = buf.readInt();
        return new OpenPlayerInventoryMessage(action);
    }

    public static void encode(OpenPlayerInventoryMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.action);
    }

    public static void handle(OpenPlayerInventoryMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> OpenPlayerInventoryMessage.onHandle(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(OpenPlayerInventoryMessage message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (message.action == 0) {
            Minecraft.m_91087_().m_91152_((Screen)new InventoryScreen((Player)player));
        }
    }
}

