/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.runtime;

import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.Expression;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.ExecutionContext;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.binding.ValueConversions;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface Function {
    public static final ArgumentCollection EMPTY_ARGUMENT = new ArgumentCollection(new ArrayList<Expression>());

    @Nullable
    public Object evaluate(@NotNull ExecutionContext<?> var1, @NotNull ArgumentCollection var2);

    default public boolean validateArgumentSize(int size) {
        return true;
    }

    public static class ArgumentCollection {
        private final List<Expression> arguments;

        public ArgumentCollection(List<Expression> arguments) {
            this.arguments = arguments;
        }

        public int size() {
            return this.arguments.size();
        }

        public String getAsString(@NotNull ExecutionContext<?> ctx, int index) {
            return ValueConversions.asString(ctx.eval(this.arguments.get(index)));
        }

        public double getAsDouble(@NotNull ExecutionContext<?> ctx, int index) {
            return ValueConversions.asDouble(ctx.eval(this.arguments.get(index)));
        }

        public int getAsInt(@NotNull ExecutionContext<?> ctx, int index) {
            return ValueConversions.asInt(ctx.eval(this.arguments.get(index)));
        }

        public float getAsFloat(@NotNull ExecutionContext<?> ctx, int index) {
            return ValueConversions.asFloat(ctx.eval(this.arguments.get(index)));
        }

        public boolean getAsBoolean(@NotNull ExecutionContext<?> ctx, int index) {
            return ValueConversions.asBoolean(ctx.eval(this.arguments.get(index)));
        }

        public Object getValue(@NotNull ExecutionContext<?> ctx, int index) {
            return ctx.eval(this.arguments.get(index));
        }

        public Expression getExpression(int index) {
            return this.arguments.get(index);
        }
    }
}

