/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.parser.ast;

import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.Expression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.ExpressionVisitor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class TernaryConditionalExpression
implements Expression {
    private final Expression conditional;
    private final Expression trueExpression;
    private final Expression falseExpression;

    public TernaryConditionalExpression(@NotNull Expression conditional, @NotNull Expression trueExpression, @NotNull Expression falseExpression) {
        this.conditional = Objects.requireNonNull(conditional, "conditional");
        this.trueExpression = Objects.requireNonNull(trueExpression, "trueExpression");
        this.falseExpression = Objects.requireNonNull(falseExpression, "falseExpression");
    }

    @NotNull
    public Expression condition() {
        return this.conditional;
    }

    @NotNull
    public Expression trueExpression() {
        return this.trueExpression;
    }

    @NotNull
    public Expression falseExpression() {
        return this.falseExpression;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitTernaryConditional(this);
    }

    public String toString() {
        return "TernaryCondition(" + this.conditional + ", " + this.trueExpression + ", " + this.falseExpression + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TernaryConditionalExpression that = (TernaryConditionalExpression)o;
        return this.conditional.equals(that.conditional) && this.trueExpression.equals(that.trueExpression) && this.falseExpression.equals(that.falseExpression);
    }

    public int hashCode() {
        return Objects.hash(this.conditional, this.trueExpression, this.falseExpression);
    }
}

