/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.lexer;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Cursor
implements Cloneable {
    private int index = 0;
    private int line = 0;
    private int column = 0;

    public Cursor(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public Cursor() {
    }

    public int index() {
        return this.index;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public void push(int character) {
        ++this.index;
        if (character == 10) {
            ++this.line;
            this.column = 1;
        } else {
            ++this.column;
        }
    }

    @NotNull
    public Cursor clone() {
        return new Cursor(this.line, this.column);
    }

    public String toString() {
        return "line " + this.line + ", column " + this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cursor that = (Cursor)o;
        return this.line == that.line && this.column == that.column;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }
}

