/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.mixin.IBlockBurningCacheMixin;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WalkNodeEvaluator.class})
public class NodeEvaluatorBurningCacher {
    @Inject(method={"isBurningBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isBurningBlock(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        IBlockBurningCacheMixin block;
        Block b = state.m_60734_();
        if (b instanceof IBlockBurningCacheMixin && (block = (IBlockBurningCacheMixin)b).touhou_little_maid$isBurning() != null) {
            cir.setReturnValue((Object)block.touhou_little_maid$isBurning());
        }
    }

    @Inject(method={"isBurningBlock"}, at={@At(value="RETURN")})
    private static void postIsBurningBlock(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        Block b = state.m_60734_();
        if (b instanceof IBlockBurningCacheMixin) {
            IBlockBurningCacheMixin block = (IBlockBurningCacheMixin)b;
            if (block.touhou_little_maid$cannotCache() != null && block.touhou_little_maid$cannotCache().booleanValue()) {
                return;
            }
            Class<?> c = b.getClass();
            if (c != Block.class) {
                try {
                    if (c.getDeclaredMethod("is", Block.class).getDeclaringClass() != Block.class) {
                        block.touhou_little_maid$setCannotCache(true);
                    }
                    return;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (Throwable error) {
                    block.touhou_little_maid$setCannotCache(true);
                    TouhouLittleMaid.LOGGER.error("Error when checking is(Block) method for caching burning state for block: " + b, error);
                    return;
                }
                try {
                    if (c.getDeclaredMethod("is", TagKey.class).getDeclaringClass() != Block.class) {
                        block.touhou_little_maid$setCannotCache(true);
                    }
                    return;
                }
                catch (NoSuchMethodException error) {
                }
                catch (Throwable error) {
                    block.touhou_little_maid$setCannotCache(true);
                    TouhouLittleMaid.LOGGER.error("Error when checking is(TagKey) method for caching burning state for block: " + b, error);
                    return;
                }
                try {
                    if (c.getDeclaredMethod("is", Holder.class).getDeclaringClass() != Block.class) {
                        block.touhou_little_maid$setCannotCache(true);
                    }
                    return;
                }
                catch (NoSuchMethodException error) {
                }
                catch (Throwable error) {
                    block.touhou_little_maid$setCannotCache(true);
                    TouhouLittleMaid.LOGGER.error("Error when checking is(Holder) method for caching burning state for block: " + b, error);
                    return;
                }
                try {
                    if (c.getDeclaredMethod("is", HolderSet.class).getDeclaringClass() != Block.class) {
                        block.touhou_little_maid$setCannotCache(true);
                    }
                    return;
                }
                catch (NoSuchMethodException error) {
                }
                catch (Throwable error) {
                    block.touhou_little_maid$setCannotCache(true);
                    TouhouLittleMaid.LOGGER.error("Error when checking is(HolderSet) method for caching burning state for block: " + b, error);
                    return;
                }
            }
            block.touhou_little_maid$setBurning((Boolean)cir.getReturnValue());
        }
    }
}

