/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.loot;

import com.github.tartaricacid.touhoulittlemaid.datapack.BoardStateData;
import com.github.tartaricacid.touhoulittlemaid.datapack.pojo.BoardStateRecord;
import com.github.tartaricacid.touhoulittlemaid.init.InitLootModifier;
import com.github.tartaricacid.touhoulittlemaid.item.ItemBoardState;
import com.github.tartaricacid.touhoulittlemaid.util.WeightedPicker;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RandomBoardStateFunction
extends LootItemConditionalFunction {
    private final List<String> tags;

    protected RandomBoardStateFunction(LootItemCondition[] predicates, List<String> tags) {
        super(predicates);
        this.tags = tags;
    }

    public static Builder create() {
        return new Builder();
    }

    private boolean checkTags(BoardStateRecord record) {
        for (String tag : this.tags) {
            if (!record.tags().contains(tag)) continue;
            return true;
        }
        return false;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        List<BoardStateRecord> records = BoardStateData.getRecordsByItem(stack);
        if (records.isEmpty()) {
            return stack;
        }
        if (this.tags.isEmpty()) {
            return stack;
        }
        List<BoardStateRecord> matchedRecords = records.stream().filter(this::checkTags).toList();
        if (matchedRecords.isEmpty()) {
            return stack;
        }
        BoardStateRecord selected = WeightedPicker.pickRandom(matchedRecords, BoardStateRecord::weight);
        if (selected == null) {
            return stack;
        }
        BoardStateRecord.Display display = selected.display();
        ItemBoardState.setState(stack, selected.data(), display.description(), display.author());
        return stack;
    }

    public LootItemFunctionType m_7162_() {
        return InitLootModifier.BOARD_STATE_RANDOMLY;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<String> tags = Lists.newArrayList();

        protected Builder getThis() {
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public LootItemFunction m_7453_() {
            return new RandomBoardStateFunction(this.m_80699_(), this.tags);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomBoardStateFunction> {
        public void serialize(JsonObject json, RandomBoardStateFunction function, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            if (function.tags.isEmpty()) {
                return;
            }
            JsonArray tags = new JsonArray();
            for (String tag : function.tags) {
                tags.add(tag);
            }
            json.add("tags", (JsonElement)tags);
        }

        public RandomBoardStateFunction deserialize(JsonObject object, JsonDeserializationContext context, LootItemCondition[] conditions) {
            if (!object.has("tags")) {
                return new RandomBoardStateFunction(conditions, Collections.emptyList());
            }
            JsonArray inputTags = object.getAsJsonArray("tags");
            if (inputTags.size() <= 0) {
                return new RandomBoardStateFunction(conditions, Collections.emptyList());
            }
            ArrayList outputTags = Lists.newArrayList();
            for (int i = 0; i < inputTags.size(); ++i) {
                String tag = inputTags.get(i).getAsString();
                outputTags.add(tag);
            }
            return new RandomBoardStateFunction(conditions, outputTags);
        }
    }
}

