/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.speex;

import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.HighLevelOggStreamPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.IOUtils;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.speex.SpeexAudioData;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.speex.SpeexInfo;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.speex.SpeexPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.speex.SpeexTags;

public class SpeexPacketFactory
extends HighLevelOggStreamPacket {
    public static boolean isSpeexStream(OggPacket firstPacket) {
        if (!firstPacket.isBeginningOfStream()) {
            return false;
        }
        return SpeexPacketFactory.isSpeexSpecial(firstPacket);
    }

    protected static boolean isSpeexSpecial(OggPacket packet) {
        byte[] d = packet.getData();
        if (d.length < 72) {
            return false;
        }
        return IOUtils.byteRangeMatches(SpeexPacket.MAGIC_HEADER_BYTES, d, 0);
    }

    public static SpeexPacket create(OggPacket packet) {
        if (SpeexPacketFactory.isSpeexSpecial(packet)) {
            return new SpeexInfo(packet);
        }
        if (packet.getSequenceNumber() == 1 && packet.getGranulePosition() == 0L) {
            return new SpeexTags(packet);
        }
        return new SpeexAudioData(packet);
    }
}

