/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemTrumpet
extends Item {
    private static final int MIN_USE_DURATION = 20;

    public ItemTrumpet() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (timeLeft >= 20) {
                if (worldIn instanceof ServerLevel) {
                    List<MaidInfo> infos;
                    ServerLevel serverLevel = (ServerLevel)worldIn;
                    serverLevel.m_143280_(EntityMaid.TYPE, Entity::m_6084_).stream().filter(maid -> maid.m_21830_((LivingEntity)player)).forEach(maid -> this.teleportToOwner((EntityMaid)maid, player));
                    MaidWorldData data = MaidWorldData.get(worldIn);
                    if (data != null && (infos = data.getPlayerMaidInfos(player)) != null && !infos.isEmpty()) {
                        player.m_213846_((Component)Component.m_237110_((String)"message.touhou_little_maid.trumpet.unloaded_maid", (Object[])new Object[]{infos.size()}).m_130940_(ChatFormatting.DARK_RED));
                    }
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "use_trumpet");
                }
                player.m_36335_().m_41524_((Item)this, 200);
            }
        }
    }

    private void teleportToOwner(EntityMaid maid, Player player) {
        maid.setHomeModeEnable(false);
        if (maid.m_20159_()) {
            maid.m_8127_();
        }
        maid.m_6021_(player.m_20185_() + (double)player.m_217043_().m_188503_(3) - 1.0, player.m_20186_(), player.m_20189_() + (double)player.m_217043_().m_188503_(3) - 1.0);
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.trumpet.desc.usage").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.trumpet.desc.note").m_130940_(ChatFormatting.DARK_RED));
    }
}

