/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAndItemTransformEvent;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.AbstractStoreMaidItem;
import com.github.tartaricacid.touhoulittlemaid.util.PlaceHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ItemSmartSlab
extends AbstractStoreMaidItem {
    private static final String MAID_OWNER = "Owner";
    private static final String INIT_MAID_OWNER = "InitMaidOwner";
    private final Type type;

    public ItemSmartSlab(Type type) {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
        this.type = type;
    }

    public static void storeMaidData(ItemStack stack, EntityMaid maid) {
        CompoundTag data = stack.m_41698_("MaidInfo");
        maid.m_20240_(data);
        MaidAndItemTransformEvent.ToItem event = new MaidAndItemTransformEvent.ToItem(maid, stack, data);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static UUID getInitMaidOwner(ItemStack stack) {
        CompoundTag data = stack.m_41784_();
        if (data.m_128425_(INIT_MAID_OWNER, 11)) {
            return data.m_128342_(INIT_MAID_OWNER);
        }
        return Util.f_137441_;
    }

    public static boolean setInitMaidOwner(ItemStack stack, UUID ownerUid) {
        Item item = stack.m_41720_();
        if (item instanceof ItemSmartSlab) {
            ItemSmartSlab smartSlab = (ItemSmartSlab)item;
            if (smartSlab.type == Type.INIT) {
                CompoundTag data = stack.m_41784_();
                data.m_128362_(INIT_MAID_OWNER, ownerUid);
                return true;
            }
        }
        return false;
    }

    public String m_5524_() {
        return "item.touhou_little_maid.smart_slab";
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Direction clickedFace = context.m_43719_();
        Player player = context.m_43723_();
        Level worldIn = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        if (player == null) {
            return super.m_6225_(context);
        }
        if (clickedFace == Direction.UP && !PlaceHelper.notSuitableForPlaceMaid(worldIn, clickedPos)) {
            EntityMaid maid = (EntityMaid)((EntityType)InitEntities.MAID.get()).m_20615_(worldIn);
            if (maid == null) {
                return super.m_6225_(context);
            }
            if (this.type == Type.INIT) {
                UUID initOwnerUid = ItemSmartSlab.getInitMaidOwner(context.m_43722_());
                if (!initOwnerUid.equals(Util.f_137441_) && !player.m_20148_().equals(initOwnerUid)) {
                    MutableComponent tip = Component.m_237115_((String)"tooltips.touhou_little_maid.smart_slab.not_your_maid").m_130940_(ChatFormatting.DARK_RED);
                    if (!worldIn.f_46443_) {
                        player.m_213846_((Component)tip);
                    }
                    return InteractionResult.FAIL;
                }
                return this.spawnNewMaid(context, player, worldIn, maid);
            }
            if (this.type == Type.HAS_MAID) {
                return this.spawnFromStore(context, player, worldIn, maid);
            }
        } else if (worldIn.f_46443_) {
            player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.photo.not_suitable_for_place_maid"));
        }
        return super.m_6225_(context);
    }

    private InteractionResult spawnFromStore(UseOnContext context, Player player, Level worldIn, EntityMaid maid) {
        ItemStack stack = context.m_43722_();
        if (ItemSmartSlab.hasMaidData(stack)) {
            CompoundTag maidData = ItemSmartSlab.getMaidData(stack);
            UUID ownerUid = maidData.m_128342_(MAID_OWNER);
            if (!player.m_20148_().equals(ownerUid)) {
                MutableComponent tip = Component.m_237115_((String)"tooltips.touhou_little_maid.smart_slab.not_your_maid").m_130940_(ChatFormatting.DARK_RED);
                if (!worldIn.f_46443_) {
                    player.m_213846_((Component)tip);
                }
                return InteractionResult.FAIL;
            }
            MaidAndItemTransformEvent.ToMaid event = new MaidAndItemTransformEvent.ToMaid(maid, stack, maidData);
            MinecraftForge.EVENT_BUS.post((Event)event);
            maid.m_20258_(maidData);
            maid.m_20035_(context.m_8083_().m_7494_(), 0.0f, 0.0f);
            if (worldIn instanceof ServerLevel) {
                worldIn.m_7967_((Entity)maid);
            }
            maid.spawnExplosionParticle();
            maid.m_5496_(SoundEvents.f_12277_, 1.0f, worldIn.f_46441_.m_188501_() * 0.1f + 0.9f);
            player.m_21008_(context.m_43724_(), ((Item)InitItems.SMART_SLAB_EMPTY.get()).m_7968_());
            player.m_36335_().m_41524_((Item)InitItems.SMART_SLAB_EMPTY.get(), 20);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6225_(context);
    }

    private InteractionResult spawnNewMaid(UseOnContext context, Player player, Level worldIn, EntityMaid maid) {
        return player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP).map(cap -> {
            if (cap.canAdd() || player.m_7500_()) {
                if (!player.m_7500_()) {
                    cap.add();
                }
                maid.m_21828_(player);
                if (worldIn instanceof ServerLevel) {
                    maid.m_6518_((ServerLevelAccessor)((ServerLevel)worldIn), worldIn.m_6436_(context.m_8083_()), MobSpawnType.SPAWN_EGG, null, null);
                    maid.m_20035_(context.m_8083_().m_7494_(), 0.0f, 0.0f);
                    worldIn.m_7967_((Entity)maid);
                }
                maid.spawnExplosionParticle();
                maid.m_5496_(SoundEvents.f_12277_, 1.0f, worldIn.f_46441_.m_188501_() * 0.1f + 0.9f);
                player.m_21008_(context.m_43724_(), ((Item)InitItems.SMART_SLAB_EMPTY.get()).m_7968_());
                player.m_36335_().m_41524_((Item)InitItems.SMART_SLAB_EMPTY.get(), 20);
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
            if (worldIn.f_46443_) {
                player.m_213846_((Component)Component.m_237110_((String)"message.touhou_little_maid.owner_maid_num.can_not_add", (Object[])new Object[]{cap.get(), cap.getMaxNum()}));
            }
            return super.m_6225_(context);
        }).orElse(super.m_6225_(context));
    }

    public boolean m_5812_(ItemStack stack) {
        return this.type != Type.EMPTY;
    }

    public boolean m_142095_() {
        return this.type != Type.HAS_MAID;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.type == Type.INIT) {
            MutableComponent text = Component.m_237110_((String)"tooltips.touhou_little_maid.smart_slab.maid_name", (Object[])new Object[]{I18n.m_118938_((String)"tooltips.touhou_little_maid.smart_slab.maid_name.unknown", (Object[])new Object[0])});
            tooltip.add((Component)text.m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.smart_slab.desc").m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (this.type == Type.HAS_MAID) {
            return super.m_142422_(stack);
        }
        return Optional.empty();
    }

    public static enum Type {
        INIT,
        EMPTY,
        HAS_MAID;

    }
}

