/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAndItemTransformEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.MaidRayTraceHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemCamera
extends Item {
    public static final String MAID_INFO = "MaidInfo";

    public ItemCamera() {
        super(new Item.Properties().m_41487_(1).m_41503_(50));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND) {
            int searchDistance = 8;
            ItemStack camera = playerIn.m_21120_(handIn);
            Optional<EntityMaid> result = MaidRayTraceHelper.rayTraceMaid(playerIn, searchDistance);
            if (result.isPresent()) {
                EntityMaid maid = result.get();
                if (!worldIn.f_46443_ && maid.m_6084_() && maid.m_21830_((LivingEntity)playerIn) && !maid.m_5803_()) {
                    this.spawnMaidPhoto(worldIn, maid, playerIn);
                    maid.m_146870_();
                    playerIn.m_36335_().m_41524_((Item)this, 20);
                    camera.m_41622_(1, (LivingEntity)playerIn, e -> e.m_21190_(InteractionHand.MAIN_HAND));
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, "photo_maid");
                    }
                }
                maid.spawnExplosionParticle();
                playerIn.m_5496_((SoundEvent)InitSounds.CAMERA_USE.get(), 1.0f, 1.0f);
                return InteractionResultHolder.m_19092_((Object)camera, (boolean)worldIn.f_46443_);
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public static void spawnMaidPhoto(Level worldIn, CompoundTag data, Player playerIn) {
        Object t;
        ItemStack photo = ((Item)InitItems.PHOTO.get()).m_7968_();
        CompoundTag photoTag = new CompoundTag();
        CompoundTag maidTag = new CompoundTag();
        Optional optional = EntityType.m_20642_((CompoundTag)data, (Level)worldIn);
        if (optional.isEmpty() || !((t = optional.get()) instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)t;
        maid.setHomeModeEnable(false);
        maid.m_20240_(maidTag);
        maidTag.m_128359_("id", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)InitEntities.MAID.get()))).toString());
        MaidAndItemTransformEvent.ToItem event = new MaidAndItemTransformEvent.ToItem(maid, photo, maidTag);
        MinecraftForge.EVENT_BUS.post((Event)event);
        photoTag.m_128365_(MAID_INFO, (Tag)maidTag);
        photo.m_41751_(photoTag);
        ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)photo);
    }

    private void spawnMaidPhoto(Level worldIn, EntityMaid maid, Player playerIn) {
        ItemStack photo = ((Item)InitItems.PHOTO.get()).m_7968_();
        CompoundTag photoTag = new CompoundTag();
        CompoundTag maidTag = new CompoundTag();
        maid.setHomeModeEnable(false);
        maid.m_20240_(maidTag);
        maidTag.m_128359_("id", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)InitEntities.MAID.get()))).toString());
        MaidAndItemTransformEvent.ToItem event = new MaidAndItemTransformEvent.ToItem(maid, photo, maidTag);
        MinecraftForge.EVENT_BUS.post((Event)event);
        photoTag.m_128365_(MAID_INFO, (Tag)maidTag);
        photo.m_41751_(photoTag);
        Containers.m_18992_((Level)worldIn, (double)playerIn.m_20185_(), (double)playerIn.m_20186_(), (double)playerIn.m_20189_(), (ItemStack)photo);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (stack.m_41720_() == this && target.m_6084_() && target instanceof EntityMaid && ((EntityMaid)target).m_21830_((LivingEntity)playerIn)) {
            this.m_7203_(playerIn.f_19853_, playerIn, hand);
            return InteractionResult.SUCCESS;
        }
        return super.m_6880_(stack, playerIn, target, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.camera.desc").m_130940_(ChatFormatting.DARK_GREEN));
    }
}

