/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.ITriggerSlotChange;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidBaubleChangeEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncBaubleMessage;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.Nullable;

public class BaubleContainer
extends MaidMainContainer {
    public static final MenuType<BaubleContainer> TYPE = IForgeMenuType.create((windowId, inv, data) -> new BaubleContainer(windowId, inv, data.readInt()));

    public BaubleContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
    }

    public static MenuProvider create(final EntityMaid maid) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Bauble Container");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory inventory, Player player) {
                int entityId = maid.m_19879_();
                return new BaubleContainer(index, inventory, entityId);
            }
        };
    }

    @Override
    protected void addMainDefaultInv() {
    }

    @Override
    protected void addBackpackInv(Inventory inventory) {
        int level = this.maid.getFavorabilityManager().getLevel();
        int maxSize = this.maid.getMaidBauble().getSlots();
        for (int y = 0; !(y >= 6 || level <= 1 && y >= 2 || level == 2 && y >= 4); ++y) {
            for (int x = 0; x < 5; ++x) {
                int index = x + y * 5;
                if (index >= maxSize) {
                    return;
                }
                this.m_38897_((Slot)new BaubleSlot(this.maid, index, 152 + 18 * x, 45 + 18 * y));
            }
        }
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack1 = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            int baubleSlots;
            ItemStack stack2 = slot.m_7993_();
            stack1 = stack2.m_41777_();
            if (index < 36 ? !this.m_38903_(stack2, baubleSlots = 42, this.f_38839_.size(), false) && !this.m_38903_(stack2, 36, baubleSlots, false) : !this.m_38903_(stack2, 0, 36, true)) {
                return ItemStack.f_41583_;
            }
            if (stack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack2.m_41613_() == stack1.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack2);
            if (slot instanceof ITriggerSlotChange) {
                ITriggerSlotChange slotChange = (ITriggerSlotChange)slot;
                slotChange.onShiftTakeoff(player, stack1);
            }
            if (36 <= index && index < 40) {
                EquipmentSlot equipmentSlot = SLOT_IDS[index - 36];
                this.maid.m_21128_(equipmentSlot, stack1);
            }
            if (40 <= index && index < 42) {
                int slotIndex = index - 36 - 4;
                EquipmentSlot equipmentSlot = slotIndex == 0 ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                this.maid.m_21168_(equipmentSlot, stack1);
            }
        }
        return stack1;
    }

    public static class BaubleSlot
    extends SlotItemHandler
    implements ITriggerSlotChange {
        private final EntityMaid maid;

        public BaubleSlot(EntityMaid maid, int index, int xPosition, int yPosition) {
            super((IItemHandler)maid.getMaidBauble(), index, xPosition, yPosition);
            this.maid = maid;
        }

        @Override
        public void onShiftTakeoff(@Nullable Player player, ItemStack stack) {
            if (this.maid.f_19853_.f_46443_ || stack.m_41619_()) {
                return;
            }
            IMaidBauble bauble = BaubleManager.getBauble(stack);
            if (bauble == null) {
                return;
            }
            bauble.onTakeOff(this.maid, stack);
            MinecraftForge.EVENT_BUS.post((Event)new MaidBaubleChangeEvent.TakeOff(this.maid, stack));
            if (bauble.syncClient(this.maid, stack)) {
                SyncBaubleMessage msg = SyncBaubleMessage.partialDel(this.maid.m_19879_(), this.m_150661_());
                NetworkHandler.sendToTrackingEntity(msg, (Entity)this.maid);
            }
        }

        public void m_142406_(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
            this.onShiftTakeoff(player, stack);
        }

        public void m_269060_(ItemStack stack) {
            super.m_269060_(stack);
            if (this.maid.f_19853_.f_46443_ || stack.m_41619_()) {
                return;
            }
            IMaidBauble bauble = BaubleManager.getBauble(stack);
            if (bauble == null) {
                return;
            }
            bauble.onPutOn(this.maid, stack);
            MinecraftForge.EVENT_BUS.post((Event)new MaidBaubleChangeEvent.PutOn(this.maid, stack));
            if (bauble.syncClient(this.maid, stack)) {
                SyncBaubleMessage msg = SyncBaubleMessage.partialSync(this.maid.m_19879_(), this.m_150661_(), stack);
                NetworkHandler.sendToTrackingEntity(msg, (Entity)this.maid);
            }
        }
    }
}

