/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimatableEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.AnimationContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Color;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.extended.LivingEntityRendererAccessor;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.EModelRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.IRenderCycle;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public abstract class GeoReplacedEntityRenderer<T extends LivingEntity, E extends AnimatableEntity<T>>
extends LivingEntityRenderer<T, HumanoidModel<T>>
implements IGeoRenderer<T> {
    protected final List<GeoLayerRenderer> layerRenderers = new ObjectArrayList();
    protected AnimatableEntity<T> currentAnimatable;
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected MultiBufferSource rtb = null;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;

    public GeoReplacedEntityRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (EntityModel)new HumanoidModel(renderManager.m_174023_(ModelLayers.f_171162_)), 0.5f);
    }

    public static int getPackedOverlay(LivingEntity entity, float u) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)u), (int)OverlayTexture.m_118096_((entity.f_20916_ > 0 || entity.f_20919_ > 0 ? 1 : 0) != 0));
    }

    private static float getFacingAngle(Direction facingIn) {
        return switch (facingIn) {
            case Direction.SOUTH -> 90.0f;
            case Direction.NORTH -> 270.0f;
            case Direction.EAST -> 180.0f;
            default -> 0.0f;
        };
    }

    private static void renderLeashPiece(VertexConsumer buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)Mth.m_14179_((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)Mth.m_14179_((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.m_109885_((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.m_252986_(positionMatrix, x - xOffset, y + yOffset, z + zOffset).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
        buffer.m_252986_(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).m_85950_(red, green, blue, 1.0f).m_85969_(packedLight).m_5752_();
    }

    @Override
    @Nonnull
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    @Override
    public float getWidthScale(T animatable) {
        return this.widthScale;
    }

    @Override
    public float getHeightScale(T entity) {
        return this.heightScale;
    }

    @Override
    public void renderEarly(T animatable, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderEarlyMat = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        IGeoRenderer.super.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlayIn, red, green, blue, alpha);
    }

    public void m_7392_(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.render(entity, this.getAnimatableEntity(entity), entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void render(T entity, E animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Direction direction;
        Entity entity2;
        Mob mob;
        Entity leashHolder;
        this.currentAnimatable = animatable;
        this.dispatchedMat = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        boolean shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(entity, (LivingEntityRenderer)this, partialTick, poseStack, bufferSource, packedLight))) {
            return;
        }
        poseStack.m_85836_();
        if (entity instanceof Mob && (leashHolder = (mob = (Mob)entity).m_21524_()) != null) {
            this.renderLeash(entity, partialTick, poseStack, bufferSource, leashHolder);
        }
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = entity.m_6162_();
        float lerpBodyRot = Mth.m_14189_((float)partialTick, (float)((LivingEntity)entity).f_20884_, (float)((LivingEntity)entity).f_20883_);
        float lerpHeadRot = Mth.m_14189_((float)partialTick, (float)((LivingEntity)entity).f_20886_, (float)((LivingEntity)entity).f_20885_);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (entity2 = entity.m_20202_()) instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            lerpBodyRot = Mth.m_14189_((float)partialTick, (float)vehicle.f_20884_, (float)vehicle.f_20883_);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (entity.m_20089_() == Pose.SLEEPING && (direction = entity.m_21259_()) != null) {
            float eyeOffset = entity.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_252880_((float)(-direction.m_122429_()) * eyeOffset, 0.0f, (float)(-direction.m_122431_()) * eyeOffset);
        }
        float lerpedAge = (float)((LivingEntity)entity).f_19797_ + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.m_7523_(entity, poseStack, lerpedAge, lerpBodyRot, partialTick);
        this.preRenderCallback((LivingEntity)entity, poseStack, partialTick);
        if (!shouldSit && entity.m_6084_()) {
            limbSwingAmount = ((LivingEntity)entity).f_267362_.m_267711_(partialTick);
            limbSwing = ((LivingEntity)entity).f_267362_.m_267590_(partialTick);
            if (entity.m_6162_()) {
                limbSwing *= 3.0f;
            }
        }
        float headPitch = Mth.m_14179_((float)partialTick, (float)((LivingEntity)entity).f_19860_, (float)entity.m_146909_());
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
        AnimationEvent<E> predicate = new AnimationEvent<E>(animatable, limbSwing, limbSwingAmount, partialTick, limbSwingAmount <= -this.getSwingMotionAnimThreshold() || limbSwingAmount <= this.getSwingMotionAnimThreshold(), Collections.singletonList(entityModelData));
        AnimationContext<T> ctx = new AnimationContext<T>(entity, this.currentAnimatable, predicate, entityModelData);
        ((AnimatableEntity)animatable).setCustomAnimations(ctx, predicate);
        AnimatedGeoModel model = ((AnimatableEntity)animatable).getCurrentModel();
        if (model != null) {
            poseStack.m_252880_(0.0f, 0.01f, 0.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation(entity));
            Color renderColor = this.getRenderColor(entity, partialTick, poseStack, bufferSource, null, packedLight);
            RenderType renderType = this.getRenderType(entity, partialTick, poseStack, bufferSource, null, packedLight, this.getTextureLocation(entity));
            if (Minecraft.m_91087_().f_91074_ != null && !entity.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
                VertexConsumer translucentBuffer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
                this.render(model, entity, partialTick, renderType, poseStack, bufferSource, translucentBuffer, packedLight, GeoReplacedEntityRenderer.getPackedOverlay(entity, this.getOverlayProgress((LivingEntity)entity, partialTick)), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
            }
        }
        if (!entity.m_5833_()) {
            for (GeoLayerRenderer layerRenderer : this.layerRenderers) {
                layerRenderer.render(poseStack, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTick, lerpedAge, netHeadYaw, headPitch);
            }
        }
        poseStack.m_85849_();
        ((LivingEntityRendererAccessor)((Object)this)).tlm$renderNameTag((LivingEntity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(entity, (LivingEntityRenderer)this, partialTick, poseStack, bufferSource, packedLight));
    }

    protected float getOverlayProgress(LivingEntity entity, float partialTicks) {
        return 0.0f;
    }

    protected void preRenderCallback(LivingEntity entity, PoseStack poseStack, float partialTick) {
    }

    @Override
    @NotNull
    public ResourceLocation getTextureLocation(T entity) {
        return ((AnimatableEntity)this.getAnimatableEntity(entity)).getTextureLocation();
    }

    protected void m_7523_(T pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.m_7523_(pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        if (((LivingEntity)pEntityLiving).f_20919_ <= 0 && pEntityLiving.m_21209_()) {
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(((float)((LivingEntity)pEntityLiving).f_19797_ + pPartialTicks) * 75.0f));
            pPoseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f + pEntityLiving.m_146909_()));
        }
    }

    protected boolean isVisible(LivingEntity entity) {
        return !entity.m_20145_();
    }

    protected float getDeathMaxRotation(LivingEntity entity) {
        return 90.0f;
    }

    public boolean m_6512_(T entity) {
        double nameRenderDistance;
        double d = nameRenderDistance = entity.m_20163_() ? 32.0 : 64.0;
        if (this.f_114476_.m_114471_(entity) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        return entity.m_6052_() || entity == this.f_114476_.f_114359_ && entity.m_8077_() && Minecraft.m_91404_();
    }

    protected float getSwingProgress(LivingEntity entity, float partialTick) {
        return entity.m_21324_(partialTick);
    }

    protected float getSwingMotionAnimThreshold() {
        return 0.15f;
    }

    public final boolean addLayer(GeoLayerRenderer<T, ?> layer) {
        return this.layerRenderers.add(layer);
    }

    public abstract E getAnimatableEntity(T var1);

    public <E extends Entity> void renderLeash(T entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, E leashHolder) {
        int segment;
        double lerpBodyAngle = Mth.m_14179_((float)partialTick, (float)((LivingEntity)entity).f_20883_, (float)((LivingEntity)entity).f_20884_) * ((float)Math.PI / 180) + 1.5707964f;
        Vec3 leashOffset = entity.m_245894_(1.0f);
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.f_82481_ + Math.sin(lerpBodyAngle) * leashOffset.f_82479_;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.f_82481_ - Math.cos(lerpBodyAngle) * leashOffset.f_82479_;
        double lerpOriginX = Mth.m_14139_((double)partialTick, (double)((LivingEntity)entity).f_19854_, (double)entity.m_20185_()) + xAngleOffset;
        double lerpOriginY = Mth.m_14139_((double)partialTick, (double)((LivingEntity)entity).f_19855_, (double)entity.m_20186_()) + leashOffset.f_82480_;
        double lerpOriginZ = Mth.m_14139_((double)partialTick, (double)((LivingEntity)entity).f_19856_, (double)entity.m_20189_()) + zAngleOffset;
        Vec3 ropeGripPosition = leashHolder.m_7398_(partialTick);
        float xDif = (float)(ropeGripPosition.f_82479_ - lerpOriginX);
        float yDif = (float)(ropeGripPosition.f_82480_ - lerpOriginY);
        float zDif = (float)(ropeGripPosition.f_82481_ - lerpOriginZ);
        float offsetMod = (float)Mth.m_14193_((double)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110475_());
        BlockPos entityEyePos = BlockPos.m_274446_((Position)entity.m_20299_(partialTick));
        BlockPos holderEyePos = BlockPos.m_274446_((Position)leashHolder.m_20299_(partialTick));
        int entityBlockLight = this.m_6086_((Entity)entity, entityEyePos);
        int holderBlockLight = leashHolder.m_6060_() ? 15 : leashHolder.m_9236_().m_45517_(LightLayer.BLOCK, holderEyePos);
        int entitySkyLight = entity.m_9236_().m_45517_(LightLayer.SKY, entityEyePos);
        int holderSkyLight = entity.m_9236_().m_45517_(LightLayer.SKY, holderEyePos);
        poseStack.m_85836_();
        poseStack.m_85837_(xAngleOffset, leashOffset.f_82480_, zAngleOffset);
        Matrix4f posMatrix = poseStack.m_85850_().m_252922_();
        for (segment = 0; segment <= 24; ++segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.m_85849_();
    }

    @Override
    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    @Override
    public void setCurrentRTB(MultiBufferSource bufferSource) {
        this.rtb = bufferSource;
    }

    public List<GeoLayerRenderer> getLayerRenderers() {
        return this.layerRenderers;
    }
}

