/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.PhysicsManager;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.Animation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationController;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.manager.AnimationData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.AnimationContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.processor.AnimationProcessor;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.RateLimiter;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.file.AnimationFile;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnimatableEntity<E extends Entity> {
    private final AnimationData manager = new AnimationData();
    private final AnimationProcessor animationProcessor;
    private final RateLimiter rateLimiter;
    protected final E entity;
    protected final PhysicsManager physicsManager;
    private AnimatedGeoModel currentModel;
    private double seekTime;
    private double lastGameTickTime;

    public AnimatableEntity(E entity, int fps) {
        this.entity = entity;
        this.rateLimiter = new RateLimiter(fps);
        this.animationProcessor = new AnimationProcessor<AnimatableEntity>(this);
        this.physicsManager = new PhysicsManager();
    }

    public void addAnimationController(AnimationController value) {
        this.manager.addAnimationController(value);
    }

    public AnimationData getAnimationData() {
        return this.manager;
    }

    public abstract ResourceLocation getModelLocation();

    public abstract ResourceLocation getTextureLocation();

    public boolean setCustomAnimations(AnimationContext<?> ctx, @NotNull AnimationEvent<?> animationEvent) {
        if (!this.updateModel()) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        double currentTick = this.getCurrentTick(animationEvent);
        if (this.manager.startTick == -1.0) {
            this.manager.startTick = currentTick;
        }
        if (!mc.m_91104_() || this.manager.shouldPlayWhilePaused) {
            double gameTick = this.manager.tick = Math.max(this.manager.tick, currentTick);
            double deltaTicks = gameTick - this.lastGameTickTime;
            this.seekTime += deltaTicks;
            this.lastGameTickTime = gameTick;
            this.codeAnimations(animationEvent);
        }
        animationEvent.animationTick = this.seekTime;
        this.animationProcessor.preAnimationSetup(this, this.seekTime);
        if (this.animationProcessor.isModelRendererEmpty()) {
            return false;
        }
        if (!this.forceUpdate(animationEvent) && !this.rateLimiter.request((float)this.seekTime * 20.0f)) {
            return false;
        }
        this.getPhysicsManager().update((float)this.seekTime);
        this.animationProcessor.tickAnimation(this.seekTime, animationEvent, ctx);
        return true;
    }

    public void codeAnimations(AnimationEvent<?> customPredicate) {
    }

    public AnimationProcessor getAnimationProcessor() {
        return this.animationProcessor;
    }

    @Nullable
    public Animation getAnimation(String name) {
        AnimationFile animation = GeckoLibCache.getInstance().getAnimations().get(this.getAnimationFileLocation());
        if (animation == null) {
            TouhouLittleMaid.LOGGER.debug("{}: Could not find animation file. Please double check name.", (Object)this.getAnimationFileLocation());
            return null;
        }
        return animation.getAnimation(name);
    }

    public abstract ResourceLocation getAnimationFileLocation();

    public boolean updateModel() {
        GeoModel model = GeckoLibCache.getInstance().getGeoModels().get(this.getModelLocation());
        if (model == null) {
            return false;
        }
        if (this.currentModel == null || model != this.currentModel.geoModel()) {
            this.currentModel = new AnimatedGeoModel(model);
            this.animationProcessor.registerModelRenderer(this.currentModel.bones());
            this.physicsManager.reset();
        }
        return true;
    }

    @Nullable
    public AnimatedGeoModel getCurrentModel() {
        return this.currentModel;
    }

    public double getCurrentTick(AnimationEvent<?> animationEvent) {
        float partialTick = animationEvent.getPartialTick();
        if (partialTick == 1.0f && partialTick != Minecraft.m_91087_().getPartialTick()) {
            partialTick = Minecraft.m_91087_().getPartialTick();
        }
        return (float)((Entity)this.entity).f_19797_ + partialTick;
    }

    public void setMolangQueries(double seekTime) {
    }

    protected boolean forceUpdate(AnimationEvent<?> animationEvent) {
        return false;
    }

    public E getEntity() {
        return this.entity;
    }

    public double getSeekTime() {
        return this.seekTime;
    }

    public PhysicsManager getPhysicsManager() {
        return this.physicsManager;
    }
}

