/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidHurtEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableFloat;

@Mod.EventBusSubscriber
public class MaidLivingEntityEvent {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            MaidHurtEvent maidHurtEvent = new MaidHurtEvent(maid, event.getSource(), event.getAmount());
            float damageAmount = MinecraftForge.EVENT_BUS.post((Event)maidHurtEvent) ? 0.0f : maidHurtEvent.getAmount();
            event.setAmount(damageAmount);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            DamageSource source = event.getSource();
            MutableFloat damage = new MutableFloat(event.getAmount());
            boolean baubleCancel = maid.getMaidBauble().fireEvent((b, s) -> b.onInjured(maid, (ItemStack)s, source, damage));
            float finalDamage = damage.getValue().floatValue();
            if (baubleCancel || finalDamage <= 0.0f) {
                event.setCanceled(true);
                return;
            }
            MaidDamageEvent maidDamageEvent = new MaidDamageEvent(maid, source, finalDamage);
            float damageAfterAbsorption = MinecraftForge.EVENT_BUS.post((Event)maidDamageEvent) ? 0.0f : maidDamageEvent.getAmount();
            event.setAmount(damageAfterAbsorption);
        }
    }
}

