/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

public enum PickType {
    ONLY_ITEM(true, false),
    ONLY_XP(false, true),
    ALL(true, true);

    private final boolean pickItem;
    private final boolean pickXp;

    private PickType(boolean pickItem, boolean pickXp) {
        this.pickItem = pickItem;
        this.pickXp = pickXp;
    }

    public boolean canPickItem() {
        return this.pickItem;
    }

    public boolean canPickXp() {
        return this.pickXp;
    }

    public static String getTransKey(PickType pickType) {
        return switch (pickType) {
            case ONLY_ITEM -> "gui.touhou_little_maid.maid_config.value.item";
            case ONLY_XP -> "gui.touhou_little_maid.maid_config.value.xp";
            default -> "gui.touhou_little_maid.maid_config.value.all";
        };
    }

    public static PickType getNextPickType(PickType pickType) {
        return PickType.values()[(pickType.ordinal() + 1) % PickType.values().length];
    }

    public static PickType getPreviousPickType(PickType pickType) {
        int index = pickType.ordinal() - 1;
        if (index < 0) {
            index = PickType.values().length - 1;
        }
        return PickType.values()[index % PickType.values().length];
    }
}

