/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.INavigationMixin;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.MaidPathNavigation;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.MaidUnderWaterPathNavigation;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;

public class MaidNavigationManager {
    private final MaidPathNavigation basicNavigation;
    private final AmphibiousPathNavigation waterNavigation;
    private final EntityMaid maid;
    private final Level level;
    private Mode mode = Mode.GROUND;

    public MaidNavigationManager(EntityMaid maid) {
        this.maid = maid;
        this.level = maid.f_19853_;
        this.basicNavigation = new MaidPathNavigation((Mob)maid, maid.f_19853_);
        this.waterNavigation = new MaidUnderWaterPathNavigation((Mob)maid, maid.f_19853_);
        maid.setNavigation((PathNavigation)this.basicNavigation);
    }

    public void tick() {
        if (!this.level.f_46443_ && this.maid.m_21515_()) {
            if (this.mode != Mode.WATER && this.maid.m_20069_() && this.shouldStartOrStopSwim(5)) {
                if (this.switchToNavigation(Mode.WATER, (PathNavigation)this.waterNavigation)) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    this.maid.getSwimManager().setReadyToLand(false);
                }
            } else if (this.mode != Mode.WATER && this.maid.m_5842_() && this.mayBeStuckUnderWater(this.maid.m_20183_())) {
                if (this.switchToNavigation(Mode.WATER, (PathNavigation)this.waterNavigation)) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    this.maid.getSwimManager().setReadyToLand(false);
                }
            } else if (this.mode != Mode.WATER && this.maid.m_20069_() && this.targetingUnderWater()) {
                if (this.switchToNavigation(Mode.WATER, (PathNavigation)this.waterNavigation)) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    this.maid.getSwimManager().setReadyToLand(false);
                }
            } else if (this.mode == Mode.WATER) {
                boolean shouldUseWater = this.maid.m_20069_() && this.targetingUnderWater() || this.maid.m_5842_() && this.mayBeStuckUnderWater(this.maid.m_20183_());
                BlockPos endPos = this.getEndPos((PathNavigation)this.waterNavigation);
                if (!shouldUseWater && endPos != null) {
                    if (!this.shouldStartOrStopSwim(2)) {
                        if (!this.level.m_46801_(endPos) && !this.level.m_46801_(endPos.m_7495_())) {
                            if (this.switchToNavigation(Mode.GROUND, (PathNavigation)this.basicNavigation)) {
                                this.maid.getSwimManager().setReadyToLand(true);
                                this.maid.getSwimManager().setWantToSwim(false);
                            }
                        } else if (this.isWaterSurface(endPos)) {
                            this.maid.getSwimManager().setWantToSwim(false);
                            this.maid.getSwimManager().setReadyToLand(false);
                        } else {
                            this.maid.getSwimManager().setWantToSwim(true);
                            this.maid.getSwimManager().setReadyToLand(false);
                        }
                    } else if (!this.maid.m_20069_()) {
                        if (this.switchToNavigation(Mode.GROUND, (PathNavigation)this.basicNavigation)) {
                            this.maid.getSwimManager().setWantToSwim(false);
                            this.maid.getSwimManager().setReadyToLand(false);
                        }
                    } else if (!this.maid.m_5842_()) {
                        this.maid.getSwimManager().setWantToSwim(false);
                    } else {
                        this.maid.getSwimManager().setWantToSwim(true);
                        this.maid.getSwimManager().setSwimTarget(endPos);
                    }
                } else if (endPos == null && this.maid.getSwimManager().isGoingToBreath()) {
                    this.maid.getSwimManager().setWantToSwim(false);
                } else if (shouldUseWater) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    if (endPos != null) {
                        this.maid.getSwimManager().setSwimTarget(endPos);
                    }
                }
            }
        }
        if (this.mode != Mode.WATER) {
            this.maid.getSwimManager().setWantToSwim(false);
        }
    }

    private boolean targetingUnderWater() {
        if (!this.maid.m_6274_().m_21874_(MemoryModuleType.f_26370_)) {
            return false;
        }
        return this.isUnderWater(((WalkTarget)this.maid.m_6274_().m_21952_(MemoryModuleType.f_26370_).get()).m_26420_().m_6675_());
    }

    private boolean switchToNavigation(Mode mode, PathNavigation navigation) {
        PathNavigation currentNavigation = this.maid.m_21573_();
        if (!currentNavigation.m_26571_()) {
            Path path = navigation.m_7864_(currentNavigation.m_26570_().m_77395_().m_77288_(), 0);
            if (path != null && path.m_77403_() && navigation.m_26536_(path, ((INavigationMixin)currentNavigation).touhouLittleMaid$GetSpeedModifier())) {
                path.m_77374_();
                this.maid.setNavigation(navigation);
                this.mode = mode;
                currentNavigation.m_26573_();
                return true;
            }
        } else {
            this.maid.setNavigation(navigation);
            navigation.m_26573_();
            currentNavigation.m_26573_();
            return true;
        }
        return false;
    }

    private boolean shouldStartOrStopSwim(int minimumDistance) {
        Path path = this.maid.m_21573_().m_26570_();
        if (path == null || path.m_77392_() || path.m_77399_() > path.m_77398_() - minimumDistance) {
            return false;
        }
        int i = path.m_77399_();
        int c = 0;
        while (c < minimumDistance) {
            if (!this.level.m_46801_(path.m_77375_(i).m_77288_())) {
                return false;
            }
            ++c;
            ++i;
        }
        return true;
    }

    private boolean mayBeStuckUnderWater(BlockPos pos) {
        return this.level.m_46801_(pos) && !this.level.m_8055_(pos.m_7494_()).m_60647_((BlockGetter)this.level, pos, PathComputationType.LAND);
    }

    public PathNavigation getBasicNavigation() {
        return this.basicNavigation;
    }

    public PathNavigation getWaterNavigation() {
        return this.waterNavigation;
    }

    public boolean isWaterSurface(BlockPos pos) {
        return this.level.m_46801_(pos) && this.level.m_8055_(pos.m_7494_()).m_60795_() || this.level.m_46801_(pos.m_7495_()) && this.level.m_8055_(pos).m_60795_() || this.level.m_46801_(pos.m_7494_()) && this.level.m_8055_(pos.m_6630_(2)).m_60795_();
    }

    private boolean isUnderWater(BlockPos blockPos) {
        return this.level.m_46801_(blockPos) && this.level.m_46801_(blockPos.m_7494_()) && this.level.m_46801_(blockPos.m_6630_(2));
    }

    @Nullable
    public BlockPos getEndPos(PathNavigation navigation) {
        if (navigation.m_26570_() == null) {
            return null;
        }
        if (navigation.m_26570_().m_77395_() == null) {
            return null;
        }
        return navigation.m_26570_().m_77395_().m_77288_();
    }

    public void resetNavigation() {
        this.maid.setNavigation((PathNavigation)this.basicNavigation);
        this.basicNavigation.m_26573_();
        this.waterNavigation.m_26573_();
        this.maid.getSwimManager().setWantToSwim(false);
        this.maid.getSwimManager().setReadyToLand(false);
        this.mode = Mode.GROUND;
    }

    public static enum Mode {
        GROUND,
        WATER;

    }
}

