/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitAttribute;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class MaidTridentTargetTask
extends Behavior<EntityMaid> {
    @Deprecated(since="1.4.7")
    private final int attackCooldown = 20;
    private int attackTime = -1;
    private int seeTime;

    public MaidTridentTargetTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        Optional memory = owner.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        if (memory.isPresent()) {
            LivingEntity target = (LivingEntity)memory.get();
            return this.hasTrident(owner) && owner.canSee(target);
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void tick(ServerLevel worldIn, EntityMaid owner, long gameTime) {
        owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> {
            boolean seeTimeMoreThanZero;
            owner.m_21563_().m_24946_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSee = owner.canSee((LivingEntity)target);
            boolean bl = seeTimeMoreThanZero = this.seeTime > 0;
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (owner.m_6117_()) {
                if (!canSee && this.seeTime < -60) {
                    owner.m_5810_();
                } else if (canSee) {
                    boolean inSafeArea;
                    int ticksUsingItem = owner.m_21252_();
                    boolean hasChanneling = EnchantmentHelper.m_44936_((ItemStack)owner.m_21205_());
                    boolean canUseChanneling = owner.f_19853_.m_46470_() && !owner.m_5842_() && hasChanneling;
                    boolean tooClose = owner.m_19950_((Entity)target, 6.0);
                    boolean bl2 = inSafeArea = !canUseChanneling || !tooClose;
                    if (ticksUsingItem >= 30 && inSafeArea) {
                        owner.m_5810_();
                        owner.m_6504_((LivingEntity)target, 0.0f);
                        AttributeInstance attributeInstance = owner.m_21051_((Attribute)InitAttribute.MAID_TRIDENT_COOLDOWN.get());
                        this.attackTime = attributeInstance != null ? (int)attributeInstance.m_22135_() : this.attackCooldown;
                    }
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                owner.m_6672_(InteractionHand.MAIN_HAND);
            }
        });
    }

    protected void stop(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        this.seeTime = 0;
        this.attackTime = -1;
        entityIn.m_5810_();
    }

    private boolean hasTrident(EntityMaid maid) {
        return maid.m_21205_().m_41720_() instanceof TridentItem;
    }
}

