/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.block.IMaidEdibleBlock;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.edible.MaidEdibleBlockAction;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.edible.MaidEdibleBlockManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidStealEdibleUseTask
extends Behavior<EntityMaid> {
    private final double closeEnoughDist;

    public MaidStealEdibleUseTask(double closeEnoughDist) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)InitEntities.MAID_EDIBLE_BLOCK_ACTION.get()), (Object)MemoryStatus.VALUE_PRESENT));
        this.closeEnoughDist = closeEnoughDist;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        Brain<EntityMaid> brain = owner.m_6274_();
        return brain.m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            Vec3 targetV3d = targetPos.m_7024_();
            if (owner.m_20238_(targetV3d) > Math.pow(this.closeEnoughDist, 2.0)) {
                Optional walkTarget = brain.m_21952_(MemoryModuleType.f_26370_);
                if (walkTarget.isEmpty() || !((WalkTarget)walkTarget.get()).m_26420_().m_7024_().equals((Object)targetV3d)) {
                    brain.m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                }
                return false;
            }
            return true;
        }).orElse(false);
    }

    protected void start(ServerLevel world, EntityMaid maid, long gameTimeIn) {
        Brain<EntityMaid> brain = maid.m_6274_();
        brain.m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(posWrapper -> brain.m_21952_((MemoryModuleType)InitEntities.MAID_EDIBLE_BLOCK_ACTION.get()).ifPresent(action -> this.handle(world, maid, (PositionTracker)posWrapper, (MaidEdibleBlockAction)((Object)((Object)action)))));
    }

    private void handle(ServerLevel world, EntityMaid maid, PositionTracker posWrapper, MaidEdibleBlockAction action) {
        BlockPos blockPos = posWrapper.m_6675_();
        BlockState blockState = world.m_8055_(blockPos);
        if (action == MaidEdibleBlockAction.TRY_STEAL) {
            for (IMaidEdibleBlock edibleBlock : MaidEdibleBlockManager.getEdibleBlocks()) {
                if (!edibleBlock.shouldMoveTo(maid, blockPos, blockState)) continue;
                boolean result = edibleBlock.consume(maid, blockPos, blockState);
                if (result) {
                    int points = edibleBlock.getFavorabilityPoints(maid, blockPos, blockState);
                    maid.getFavorabilityManager().apply(Type.STEAL_EDIBLE_BLOCK, points);
                    maid.m_6674_(InteractionHand.MAIN_HAND);
                }
                maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                return;
            }
        } else {
            CombinedInvWrapper inv = maid.getAvailableInv(true);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                for (IMaidEdibleBlock edibleBlock : MaidEdibleBlockManager.getEdibleBlocks()) {
                    if (!edibleBlock.canPlaceAsFood(maid, stack, i)) continue;
                    boolean result = edibleBlock.placeAsFood(maid, blockPos, stack, i);
                    if (result) {
                        maid.m_6674_(InteractionHand.MAIN_HAND);
                    }
                    maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                    maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                    return;
                }
            }
        }
    }
}

