/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.block.IMaidEdibleBlock;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidMoveToBlockTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.edible.MaidEdibleBlockAction;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.edible.MaidEdibleBlockManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidStealEdibleMoveBlockTask
extends MaidMoveToBlockTask {
    private static final int HORIZONTAL_SEARCH_RANGE = 5;
    private static final int NEXT_CHECK_TICK_COUNT = 900;
    private static final BoundingBox CHECK_RANGE = new BoundingBox(-1, -1, -1, 1, 1, 1);
    @VisibleForDebug
    public static boolean DEBUG = false;
    private final MemoryModuleType<MaidEdibleBlockAction> action;
    @Nullable
    private ItemStack placedStack;

    public MaidStealEdibleMoveBlockTask(float movementSpeed) {
        super(movementSpeed, 2);
        this.setMaxCheckRate(900);
        this.action = (MemoryModuleType)InitEntities.MAID_EDIBLE_BLOCK_ACTION.get();
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        if (DEBUG) {
            return true;
        }
        return super.checkExtraStartConditions(worldIn, owner);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        Optional memory = maid.m_6274_().m_21952_(this.action);
        if (memory.isPresent() && memory.get() == MaidEdibleBlockAction.TRY_STEAL) {
            CombinedInvWrapper inv = maid.getAvailableInv(true);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                for (IMaidEdibleBlock edibleBlock : MaidEdibleBlockManager.getEdibleBlocks()) {
                    if (!edibleBlock.canPlaceAsFood(maid, stack, i)) continue;
                    this.placedStack = stack;
                    maid.m_6274_().m_21879_(this.action, (Object)MaidEdibleBlockAction.TRY_PLACE);
                    this.searchForDestination(worldIn, maid);
                    return;
                }
            }
            maid.m_6274_().m_21879_(this.action, (Object)MaidEdibleBlockAction.TRY_STEAL);
        } else {
            maid.m_6274_().m_21879_(this.action, (Object)MaidEdibleBlockAction.TRY_STEAL);
        }
        this.searchForDestination(worldIn, maid);
    }

    @Override
    protected boolean shouldMoveTo(ServerLevel worldIn, EntityMaid maid, BlockPos pos) {
        BlockState blockState = worldIn.m_8055_(pos);
        MaidEdibleBlockAction memory = maid.m_6274_().m_21952_(this.action).orElse(MaidEdibleBlockAction.TRY_STEAL);
        for (IMaidEdibleBlock edibleBlock : MaidEdibleBlockManager.getEdibleBlocks()) {
            if (memory == MaidEdibleBlockAction.TRY_PLACE) {
                if (this.placedStack == null) {
                    return false;
                }
                if (!edibleBlock.shouldPlaceTo(maid, pos, blockState, this.placedStack)) continue;
                return true;
            }
            if (!edibleBlock.shouldMoveTo(maid, pos, blockState)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean checkPathReach(EntityMaid maid, MaidPathFindingBFS pathFinding, BlockPos pos) {
        for (int x = CHECK_RANGE.m_162395_(); x <= CHECK_RANGE.m_162399_(); ++x) {
            for (int y = CHECK_RANGE.m_162396_(); y <= CHECK_RANGE.m_162400_(); ++y) {
                for (int z = CHECK_RANGE.m_162398_(); z <= CHECK_RANGE.m_162401_(); ++z) {
                    if (!pathFinding.canPathReach(pos.m_7918_(x, y, z))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected int getHorizontalSearchRange(EntityMaid maid) {
        int defaultRange = super.getHorizontalSearchRange(maid);
        return Math.min(defaultRange, 5);
    }

    @Override
    protected void setNextCheckTickCount(int nextCheckTickCount) {
        super.setNextCheckTickCount(900);
    }
}

