/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitAttribute;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.behavior.CrossbowAttack;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public class MaidCrossbowAttack
extends CrossbowAttack<EntityMaid, EntityMaid> {
    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_26372_).map(target -> maid.m_21093_(this::isCrossbow) && maid.canSee((LivingEntity)target)).orElse(false);
    }

    private boolean isCrossbow(ItemStack stack) {
        return stack.m_41720_() instanceof CrossbowItem;
    }

    public void crossbowAttack(EntityMaid shooter, LivingEntity target) {
        if (this.f_22772_ == CrossbowAttack.CrossbowState.UNCHARGED) {
            shooter.m_6672_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)shooter, item -> item instanceof CrossbowItem));
            this.f_22772_ = CrossbowAttack.CrossbowState.CHARGING;
            shooter.m_6136_(true);
        } else if (this.f_22772_ == CrossbowAttack.CrossbowState.CHARGING) {
            ItemStack crossbowStack;
            int useTicks;
            if (!shooter.m_6117_()) {
                this.f_22772_ = CrossbowAttack.CrossbowState.UNCHARGED;
            }
            if ((useTicks = shooter.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(crossbowStack = shooter.m_21211_()))) {
                shooter.m_21253_();
                this.f_22772_ = CrossbowAttack.CrossbowState.CHARGED;
                this.f_22771_ = 20 + shooter.m_217043_().m_188503_(20);
                AttributeInstance attribute = shooter.m_21051_((Attribute)InitAttribute.MAID_CROSSBOW_ATTACK_SPEED.get());
                if (attribute != null) {
                    this.f_22771_ = (int)((double)this.f_22771_ / attribute.m_22135_());
                }
                shooter.m_6136_(false);
            }
        } else if (this.f_22772_ == CrossbowAttack.CrossbowState.CHARGED) {
            --this.f_22771_;
            if (this.f_22771_ <= 0) {
                this.f_22772_ = CrossbowAttack.CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.f_22772_ == CrossbowAttack.CrossbowState.READY_TO_ATTACK) {
            shooter.m_6504_(target, 1.0f);
            ItemStack usedCrossbowStack = shooter.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)shooter, item -> item instanceof CrossbowItem));
            CrossbowItem.m_40884_((ItemStack)usedCrossbowStack, (boolean)false);
            this.f_22772_ = CrossbowAttack.CrossbowState.UNCHARGED;
        }
    }
}

