/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.debug.target;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DebugMaidManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="touhou_little_maid")
@VisibleForDebug
public class SendMaidDebugDataEvent {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (!TouhouLittleMaid.DEBUG) {
            return;
        }
        if (event.phase != TickEvent.Phase.END || !event.side.isServer() || !((player = event.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (event.player.f_19797_ % 4 == 0) {
            List<EntityMaid> debuggingMaid = DebugMaidManager.getDebuggingMaid(serverPlayer);
            for (EntityMaid maid : debuggingMaid) {
                SendMaidDebugDataEvent.renderForMaid(maid, serverPlayer);
            }
        }
    }

    private static void renderForMaid(@Nullable EntityMaid maid, ServerPlayer player) {
        Path path;
        if (maid == null) {
            return;
        }
        if (!maid.m_21573_().m_26571_() && (path = maid.m_21573_().m_26570_()) != null) {
            FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
            byteBuf.writeInt(maid.m_19879_());
            byteBuf.writeFloat(0.5f);
            path.m_164704_(byteBuf);
            player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(ClientboundCustomPayloadPacket.f_132013_, byteBuf));
        }
        DebugMaidManager.getDebugTargets(maid).forEach(target -> {
            FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
            byteBuf.m_130064_(target.pos());
            byteBuf.writeInt(target.color());
            byteBuf.m_130070_(target.text());
            byteBuf.writeInt(target.lifeTime());
            player.f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(ClientboundCustomPayloadPacket.f_132026_, byteBuf));
        });
    }
}

