/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.advancements.altar.AltarCraftTrigger;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.datagen.LanguageGenerator;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.PickedUpItemTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;

public class MaidBaseAdvancement {
    public static void generate(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement root = MaidBaseAdvancement.make((ItemLike)Items.f_42402_, "switch_task").m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("switch_task")).save(saver, MaidBaseAdvancement.id("maid_base/switch_task"), existingFileHelper);
        MaidBaseAdvancement.generateTask(root, saver, existingFileHelper);
        MaidBaseAdvancement.generateOther(saver, existingFileHelper, root);
        MaidBaseAdvancement.generateBauble(root, saver, existingFileHelper);
        MaidBaseAdvancement.generatePhoto(root, saver, existingFileHelper);
        MaidBaseAdvancement.generateFind(saver, existingFileHelper, root);
        MaidBaseAdvancement.generateReborn(root, saver, existingFileHelper);
    }

    private static void generateFind(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper, Advancement root) {
        Advancement base = MaidBaseAdvancement.make((ItemLike)InitItems.SERVANT_BELL.get(), "use_servant_bell").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("use_servant_bell")).save(saver, MaidBaseAdvancement.id("maid_base/use_servant_bell"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)InitItems.TRUMPET.get(), "use_trumpet").m_138398_(base).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("use_trumpet")).save(saver, MaidBaseAdvancement.id("maid_base/use_trumpet"), existingFileHelper);
        Advancement redFoxScroll = MaidBaseAdvancement.make((ItemLike)InitItems.RED_FOX_SCROLL.get(), "use_red_fox_scroll").m_138398_(base).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("use_red_fox_scroll")).save(saver, MaidBaseAdvancement.id("maid_base/use_red_fox_scroll"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)InitItems.WHITE_FOX_SCROLL.get(), "use_white_fox_scroll").m_138398_(redFoxScroll).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("use_white_fox_scroll")).save(saver, MaidBaseAdvancement.id("maid_base/use_white_fox_scroll"), existingFileHelper);
    }

    private static void generateOther(Consumer<Advancement> saver, ExistingFileHelper existingFileHelper, Advancement root) {
        Advancement base = MaidBaseAdvancement.make((ItemLike)Items.f_42450_, "pickup_maid").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("pickup_maid")).save(saver, MaidBaseAdvancement.id("maid_base/pickup_maid"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)Items.f_42612_, "take_maid_xp").m_138398_(base).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("take_maid_xp")).save(saver, MaidBaseAdvancement.id("maid_base/take_maid_xp"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)Items.f_42455_, "clear_maid_effects").m_138398_(base).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("clear_maid_effects")).save(saver, MaidBaseAdvancement.id("maid_base/clear_maid_effects"), existingFileHelper);
    }

    private static void generateTask(Advancement root, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement taskRoot = MaidBaseAdvancement.make((ItemLike)Items.f_42524_, "switch_schedule").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("switch_schedule")).save(saver, MaidBaseAdvancement.id("maid_base/switch_schedule"), existingFileHelper);
        Advancement backpack = MaidBaseAdvancement.make((ItemLike)InitItems.MAID_BACKPACK_BIG.get(), "maid_backpack").m_138398_(taskRoot).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_backpack")).save(saver, MaidBaseAdvancement.id("maid_base/maid_backpack"), existingFileHelper);
        MaidBaseAdvancement.makeGoal((ItemLike)Items.f_42388_, "maid_kill_mob").m_138398_(backpack).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_kill_mob")).save(saver, MaidBaseAdvancement.id("maid_base/maid_kill_mob"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)Items.f_42523_, "maid_fishing").m_138398_(backpack).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_fishing")).save(saver, MaidBaseAdvancement.id("maid_base/maid_fishing"), existingFileHelper);
        Advancement farm = MaidBaseAdvancement.makeGoal((ItemLike)Items.f_42387_, "maid_farm").m_138398_(taskRoot).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_farm")).save(saver, MaidBaseAdvancement.id("maid_base/maid_farm"), existingFileHelper);
        Advancement feedAnimal = MaidBaseAdvancement.make((ItemLike)Items.f_42405_, "maid_feed_animal").m_138398_(farm).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_feed_animal")).save(saver, MaidBaseAdvancement.id("maid_base/maid_feed_animal"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)Items.f_42580_, "maid_feed_player").m_138398_(feedAnimal).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("maid_feed_player")).save(saver, MaidBaseAdvancement.id("maid_base/maid_feed_player"), existingFileHelper);
    }

    private static void generateBauble(Advancement root, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement baubleRoot = MaidBaseAdvancement.make((ItemLike)InitItems.FIRE_PROTECT_BAUBLE.get(), "use_protect_bauble").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("use_protect_bauble")).save(saver, MaidBaseAdvancement.id("maid_base/use_protect_bauble"), existingFileHelper);
        Advancement fabric = MaidBaseAdvancement.make((ItemLike)InitItems.NIMBLE_FABRIC.get(), "use_nimble_fabric").m_138398_(baubleRoot).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("use_nimble_fabric")).save(saver, MaidBaseAdvancement.id("maid_base/use_nimble_fabric"), existingFileHelper);
        MaidBaseAdvancement.makeGoal((ItemLike)InitItems.ULTRAMARINE_ORB_ELIXIR.get(), "use_undead_bauble").m_138398_(fabric).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("use_undead_bauble")).save(saver, MaidBaseAdvancement.id("maid_base/use_undead_bauble"), existingFileHelper);
        Advancement magnet = MaidBaseAdvancement.make((ItemLike)InitItems.ITEM_MAGNET_BAUBLE.get(), "use_item_magnet_bauble").m_138398_(baubleRoot).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("use_item_magnet_bauble")).save(saver, MaidBaseAdvancement.id("maid_base/use_item_magnet_bauble"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)InitItems.WIRELESS_IO.get(), "use_wireless_io").m_138398_(magnet).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("use_wireless_io")).save(saver, MaidBaseAdvancement.id("maid_base/use_wireless_io"), existingFileHelper);
    }

    private static void generatePhoto(Advancement root, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        Advancement photoRoot = MaidBaseAdvancement.make((ItemLike)InitItems.CAMERA.get(), "photo_maid").m_138398_(root).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("photo_maid")).save(saver, MaidBaseAdvancement.id("maid_base/photo_maid"), existingFileHelper);
        Advancement statue = MaidBaseAdvancement.make((ItemLike)InitItems.CHISEL.get(), "chisel_statue").m_138398_(photoRoot).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("chisel_statue")).save(saver, MaidBaseAdvancement.id("maid_base/chisel_statue"), existingFileHelper);
        MaidBaseAdvancement.make((ItemLike)InitItems.GARAGE_KIT.get(), "pickup_garage_kit").m_138398_(statue).m_138386_("pickup_item", (CriterionTriggerInstance)PickedUpItemTrigger.TriggerInstance.m_286101_((ContextAwarePredicate)ContextAwarePredicate.f_285567_, (ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)InitItems.GARAGE_KIT.get()}).m_45077_(), (ContextAwarePredicate)ContextAwarePredicate.f_285567_)).save(saver, MaidBaseAdvancement.id("maid_base/pickup_garage_kit"), existingFileHelper);
    }

    private static void generateReborn(Advancement root, Consumer<Advancement> saver, ExistingFileHelper existingFileHelper) {
        ItemStack stack = ItemEntityPlaceholder.setRecipeId(new ItemStack((ItemLike)InitItems.ENTITY_PLACEHOLDER.get()), MaidBaseAdvancement.id("altar/reborn_maid"));
        Advancement rebornRoot = MaidBaseAdvancement.make(stack, "reborn_maid").m_138398_(root).m_138386_("altar_craft", (CriterionTriggerInstance)AltarCraftTrigger.Instance.recipe(MaidBaseAdvancement.id("altar/reborn_maid"))).save(saver, MaidBaseAdvancement.id("maid_base/reborn_maid"), existingFileHelper);
        MaidBaseAdvancement.makeGoal((ItemLike)InitItems.SHRINE.get(), "shrine_reborn_maid").m_138398_(rebornRoot).m_138386_("maid_event", (CriterionTriggerInstance)MaidEventTrigger.create("shrine_reborn_maid")).save(saver, MaidBaseAdvancement.id("maid_base/shrine_reborn_maid"), existingFileHelper);
    }

    private static Advancement.Builder make(ItemLike item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.maid_base.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.maid_base.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138371_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.TASK, true, true, false);
    }

    private static Advancement.Builder make(ItemStack item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.maid_base.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.maid_base.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138362_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.TASK, true, true, false);
    }

    private static Advancement.Builder makeGoal(ItemLike item, String key) {
        MutableComponent title = Component.m_237115_((String)String.format("advancements.touhou_little_maid.maid_base.%s.title", key));
        MutableComponent desc = Component.m_237115_((String)String.format("advancements.touhou_little_maid.maid_base.%s.description", key));
        LanguageGenerator.addLanguage(title);
        LanguageGenerator.addLanguage(desc);
        return Advancement.Builder.m_138353_().m_138371_(item, (Component)title, (Component)desc, new ResourceLocation("touhou_little_maid", "textures/advancements/backgrounds/stone.png"), FrameType.GOAL, true, true, false);
    }

    private static ResourceLocation id(String id) {
        return new ResourceLocation("touhou_little_maid", id);
    }
}

