/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.loot.RandomBoardStateFunction;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.loot.packs.VanillaChestLoot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class LootTableGenerator {
    public static final ResourceLocation ADVANCEMENT_POWER_POINT = new ResourceLocation("touhou_little_maid", "advancement/power_point");
    public static final ResourceLocation CAKE = new ResourceLocation("touhou_little_maid", "advancement/cake");
    public static final ResourceLocation CHEST_POWER_POINT = new ResourceLocation("touhou_little_maid", "chest/power_point");
    public static final ResourceLocation FISHING_POWER_POINT = new ResourceLocation("touhou_little_maid", "fishing/power_point");
    public static final ResourceLocation SHRINE_LESS = new ResourceLocation("touhou_little_maid", "chest/shrine_less");
    public static final ResourceLocation SHRINE_MORE = new ResourceLocation("touhou_little_maid", "chest/shrine_more");
    public static final ResourceLocation SPAWN_BONUS = new ResourceLocation("touhou_little_maid", "chest/spawn_bonus");
    public static final ResourceLocation NORMAL_BACKPACK = new ResourceLocation("touhou_little_maid", "chest/normal_backpack");
    public static final ResourceLocation FURNACE_OR_CRAFTING_TABLE_BACKPACK = new ResourceLocation("touhou_little_maid", "chest/furnace_or_crafting_table_backpack");
    public static final ResourceLocation TANK_BACKPACK = new ResourceLocation("touhou_little_maid", "chest/tank_backpack");
    public static final ResourceLocation ENDER_CHEST_BACKPACK = new ResourceLocation("touhou_little_maid", "chest/ender_chest_backpack");
    public static final ResourceLocation NORMAL_BAUBLE = new ResourceLocation("touhou_little_maid", "chest/normal_bauble");
    public static final ResourceLocation RARE_BAUBLE = new ResourceLocation("touhou_little_maid", "chest/rare_bauble");
    public static final ResourceLocation VERY_RARE_BAUBLE = new ResourceLocation("touhou_little_maid", "chest/very_rare_bauble");
    public static final ResourceLocation STRUCTURE_SPAWN_MAID_GIFT = new ResourceLocation("touhou_little_maid", "chest/structure_spawn_maid_gift");
    public static final ResourceLocation MAID_BURIED_TREASURE = new ResourceLocation("touhou_little_maid", "chest/maid_buried_treasure");
    public static final ResourceLocation RANDOM_BOARD_STATE = new ResourceLocation("touhou_little_maid", "chest/random_board_state");

    public static class EntityLootTables
    extends EntityLootSubProvider {
        public final Set<EntityType<?>> knownEntities = Sets.newHashSet();

        protected EntityLootTables() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            this.m_245309_((EntityType)InitEntities.BOX.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42516_))));
        }

        protected boolean m_245552_(EntityType<?> type) {
            return true;
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return this.knownEntities.stream();
        }

        protected void m_245309_(EntityType<?> type, LootTable.Builder builder) {
            this.m_247520_(type, type.m_20677_(), builder);
        }

        protected void m_247520_(EntityType<?> type, ResourceLocation lootTable, LootTable.Builder builder) {
            super.m_247520_(type, lootTable, builder);
            this.knownEntities.add(type);
        }
    }

    public static class ChestLootTables
    extends VanillaChestLoot {
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(CHEST_POWER_POINT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.POWER_POINT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(2))));
            consumer.accept(FISHING_POWER_POINT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.POWER_POINT.get()))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(9))));
            consumer.accept(SHRINE_LESS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.SHRINE.get()))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(9))));
            consumer.accept(SHRINE_MORE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.SHRINE.get()))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(2))));
            consumer.accept(SPAWN_BONUS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_SMALL.get())).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_MIDDLE.get())).m_79707_(9)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_BIG.get())).m_79707_(4))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.POWER_POINT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)9.0f))))));
            consumer.accept(NORMAL_BACKPACK, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_SMALL.get())).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_MIDDLE.get())).m_79707_(9)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.MAID_BACKPACK_BIG.get())).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(50))));
            consumer.accept(FURNACE_OR_CRAFTING_TABLE_BACKPACK, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.FURNACE_BACKPACK.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.CRAFTING_TABLE_BACKPACK.get()))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(8))));
            LootPoolSingletonContainer.Builder tank1 = LootItem.m_79579_((ItemLike)((ItemLike)InitItems.TANK_BACKPACK.get())).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)this.getLavaFluidStackTag(9)));
            LootPoolSingletonContainer.Builder tank2 = LootItem.m_79579_((ItemLike)((ItemLike)InitItems.TANK_BACKPACK.get())).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)this.getLavaFluidStackTag(4)));
            LootPoolSingletonContainer.Builder tank3 = LootItem.m_79579_((ItemLike)((ItemLike)InitItems.TANK_BACKPACK.get())).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)this.getLavaFluidStackTag(3)));
            consumer.accept(TANK_BACKPACK, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)tank1).m_79076_((LootPoolEntryContainer.Builder)tank2).m_79076_((LootPoolEntryContainer.Builder)tank3).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(12))));
            consumer.accept(ENDER_CHEST_BACKPACK, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.ENDER_CHEST_BACKPACK.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(4))));
            consumer.accept(NORMAL_BAUBLE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.EXPLOSION_PROTECT_BAUBLE.get())).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.FIRE_PROTECT_BAUBLE.get())).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.PROJECTILE_PROTECT_BAUBLE.get())).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.MAGIC_PROTECT_BAUBLE.get())).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.FALL_PROTECT_BAUBLE.get())).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.DROWN_PROTECT_BAUBLE.get())).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.EXPLOSION_PROTECT_BAUBLE.get())).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.FIRE_PROTECT_BAUBLE.get())).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.PROJECTILE_PROTECT_BAUBLE.get())).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.MAGIC_PROTECT_BAUBLE.get())).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.FALL_PROTECT_BAUBLE.get())).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.DROWN_PROTECT_BAUBLE.get())).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(90))));
            consumer.accept(RARE_BAUBLE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.NIMBLE_FABRIC.get())).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.NIMBLE_FABRIC.get()))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.ITEM_MAGNET_BAUBLE.get()))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(6))));
            consumer.accept(VERY_RARE_BAUBLE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.ULTRAMARINE_ORB_ELIXIR.get())).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_80440_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.ULTRAMARINE_ORB_ELIXIR.get())).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(4))));
            LootItemConditionalFunction.Builder setDamage = SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)0.06f, (float)0.1f));
            consumer.accept(STRUCTURE_SPAWN_MAID_GIFT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42502_))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.CAMERA.get())).m_79078_((LootItemFunction.Builder)setDamage))));
            consumer.accept(MAID_BURIED_TREASURE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.SMART_SLAB_EMPTY.get()))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(4))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.SHRINE.get()))).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_())));
            RandomBoardStateFunction.Builder library = RandomBoardStateFunction.create().addTag("library");
            consumer.accept(RANDOM_BOARD_STATE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.GOMOKU_BOARD_STATE.get())).m_79078_((LootItemFunction.Builder)library)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.CCHESS_BOARD_STATE.get())).m_79078_((LootItemFunction.Builder)library)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.WCHESS_BOARD_STATE.get())).m_79078_((LootItemFunction.Builder)library))));
        }

        @NotNull
        private CompoundTag getLavaFluidStackTag(int count) {
            CompoundTag tankTag = new CompoundTag();
            FluidStack fluidStack = new FluidStack((Fluid)Fluids.f_76195_, count * 1000);
            tankTag.m_128365_("Tanks", (Tag)fluidStack.writeToNBT(new CompoundTag()));
            return tankTag;
        }
    }

    public static class AdvancementLootTables
    implements LootTableSubProvider {
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ADVANCEMENT_POWER_POINT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)InitItems.POWER_POINT.get())))));
            consumer.accept(CAKE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42502_))));
        }
    }
}

