/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.TaskBuilder;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidMeleeAttack;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUseShieldTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MeleeTaskJS
implements IAttackTask {
    private final Builder builder;

    public MeleeTaskJS(Builder builder) {
        this.builder = builder;
    }

    @Override
    public ResourceLocation getUid() {
        return this.builder.id;
    }

    @Override
    public ItemStack getIcon() {
        return this.builder.icon;
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        if (this.builder.sound == null) {
            return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_ATTACK.get(), 0.5f);
        }
        return this.builder.sound;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(m -> this.isWeapon((EntityMaid)m, m.m_21205_()), IAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.isWeapon(maid, maid.m_21205_()) || maid.m_20270_((Entity)target) > maid.m_21535_());
        BehaviorControl moveToTargetTask = SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)this.builder.walkSpeed);
        OneShot<EntityMaid> attackTargetTask = MaidMeleeAttack.create(this.builder.meleeCooldownTick);
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        ArrayList tasks = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)moveToTargetTask), Pair.of((Object)5, attackTargetTask), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
        for (Pair pair : this.builder.brains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((BehaviorControl)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(m -> this.isWeapon((EntityMaid)m, m.m_21205_()), IAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.isWeapon(maid, maid.m_21205_()) || this.farAway((LivingEntity)target, maid));
        OneShot<EntityMaid> attackTargetTask = MaidMeleeAttack.create(this.builder.meleeCooldownTick);
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        ArrayList tasks = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, attackTargetTask), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
        for (Pair pair : this.builder.rideBrains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((BehaviorControl)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public boolean isEnable(EntityMaid maid) {
        if (this.builder.enable == null) {
            return true;
        }
        return this.builder.enable.test(maid);
    }

    @Override
    public boolean isHidden(EntityMaid maid) {
        if (this.builder.isHidden == null) {
            return false;
        }
        return this.builder.isHidden.test(maid);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        if (this.builder.enableLookAndRandomWalk == null) {
            return true;
        }
        return this.builder.enableLookAndRandomWalk.test(maid);
    }

    @Override
    public boolean enableEating(EntityMaid maid) {
        if (this.builder.enableEating == null) {
            return true;
        }
        return this.builder.enableEating.test(maid);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return this.builder.enableConditionDesc;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return this.builder.conditionDesc;
    }

    @Override
    public boolean canAttack(EntityMaid maid, LivingEntity target) {
        if (this.builder.canAttack == null) {
            return IAttackTask.super.canAttack(maid, target);
        }
        return this.builder.canAttack.test(maid, target);
    }

    @Override
    public boolean hasExtraAttack(EntityMaid maid, Entity target) {
        if (this.builder.hasExtraAttack == null) {
            return false;
        }
        return this.builder.hasExtraAttack.test(maid, target);
    }

    @Override
    public boolean doExtraAttack(EntityMaid maid, Entity target) {
        if (this.builder.doExtraAttack == null) {
            return false;
        }
        return this.builder.doExtraAttack.test(maid, target);
    }

    @Override
    public boolean isWeapon(EntityMaid maid, ItemStack stack) {
        if (this.builder.isWeapon == null) {
            return false;
        }
        return this.builder.isWeapon.test(maid, stack);
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        if (!target.m_6084_()) {
            return true;
        }
        boolean enable = maid.isHomeModeEnable();
        float radius = maid.m_21535_();
        if (!enable && maid.m_269323_() != null) {
            return maid.m_269323_().m_20270_((Entity)target) > radius;
        }
        return maid.m_20270_((Entity)target) > radius;
    }

    public static class Builder
    extends TaskBuilder<Builder, MeleeTaskJS> {
        @Nullable
        private BiPredicate<EntityMaid, LivingEntity> canAttack = null;
        @Nullable
        private BiPredicate<EntityMaid, Entity> hasExtraAttack = null;
        @Nullable
        private BiPredicate<EntityMaid, Entity> doExtraAttack = null;
        @Nullable
        private BiPredicate<EntityMaid, ItemStack> isWeapon = null;
        private float walkSpeed = 0.6f;
        private int meleeCooldownTick = 20;

        public Builder(ResourceLocation id, ItemStack icon) {
            super(id, icon);
        }

        @Info(value="Sets the condition for whether the maid can attack a target. Default is all hostile entities. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u662f\u5426\u53ef\u4ee5\u653b\u51fb\u76ee\u6807\u7684\u6761\u4ef6\u3002\u9ed8\u8ba4\u4e3a\u6240\u6709\u654c\u5bf9\u751f\u7269\u3002\n")
        public Builder canAttack(BiPredicate<EntityMaid, LivingEntity> canAttack) {
            this.canAttack = canAttack;
            return this;
        }

        @Info(value="Sets the condition for whether the maid has an extra attack against a target. Default is false. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u662f\u5426\u5bf9\u76ee\u6807\u6709\u989d\u5916\u653b\u51fb\u7684\u6761\u4ef6\u3002\u9ed8\u8ba4\u4e3a false\u3002\n")
        public Builder hasExtraAttack(BiPredicate<EntityMaid, Entity> hasExtraAttack) {
            this.hasExtraAttack = hasExtraAttack;
            return this;
        }

        @Info(value="Sets the action for the maid to perform an extra attack against a target. Default is empty. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u5bf9\u76ee\u6807\u6267\u884c\u989d\u5916\u653b\u51fb\u7684\u52a8\u4f5c\u3002\u9ed8\u8ba4\u4e3a\u7a7a\u3002\n")
        public Builder doExtraAttack(BiPredicate<EntityMaid, Entity> doExtraAttack) {
            this.doExtraAttack = doExtraAttack;
            return this;
        }

        @Info(value="Sets the condition for whether the maid considers an item as a weapon. Mandatory. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u662f\u5426\u5c06\u5f53\u524d\u7269\u54c1\u89c6\u4e3a\u6b66\u5668\u7684\u6761\u4ef6\u3002\u5fc5\u586b\u9879\u3002\n")
        public Builder isWeapon(BiPredicate<EntityMaid, ItemStack> isWeapon) {
            this.isWeapon = isWeapon;
            return this;
        }

        @Info(value="Sets the walk speed for the maid when moving towards a target. Default is 0.6. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u5728\u63a5\u8fd1\u76ee\u6807\u65f6\u7684\u79fb\u52a8\u901f\u5ea6\u3002\u9ed8\u8ba4\u4e3a 0.6\u3002\n")
        public Builder walkSpeed(float walkSpeed) {
            this.walkSpeed = walkSpeed;
            return this;
        }

        @Info(value="Sets the cooldown tick for the attack. Default is 20 ticks. <br>\n\u8bbe\u7f6e\u653b\u51fb\u7684\u51b7\u5374\u65f6\u95f4\uff08\u4ee5 tick \u4e3a\u5355\u4f4d\uff09\u3002\u9ed8\u8ba4\u503c\u4e3a 20 ticks\u3002\n")
        public Builder meleeCooldownTick(int meleeCooldownTick) {
            this.meleeCooldownTick = meleeCooldownTick;
            return this;
        }
    }
}

