/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.builder;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.BaseTaskJS;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.FarmTaskJS;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.MeleeTaskJS;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.RangedAttackTaskJS;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.WalkToBlockTaskJS;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.WalkToLivingEntityTaskJS;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class MaidTaskBuilder {
    private final List<IMaidTask> tasks = Lists.newArrayList();

    @Info(value="Creates a new blank task builder. It does not contain any Brain content, you need to add Brain using java.forClass. <br>\n\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u7a7a\u767d\u7684\u4efb\u52a1\u6784\u5efa\u5668\u3002\u91cc\u9762\u6ca1\u6709 Brain \u5185\u5bb9\uff0c\u9700\u8981\u81ea\u884c\u4f7f\u7528 java.forClass \u6765\u6dfb\u52a0 Brain\u3002\n", params={@Param(name="id", value="The unique identifier for the task. <br>\n\u4efb\u52a1\u7684 ID\n"), @Param(name="icon", value="use an item to represent the task icon <br>\n\u7528\u7269\u54c1\u6765\u8868\u793a\u4efb\u52a1\u7684\u56fe\u6807\n")})
    public BaseTaskJS.Builder baseTask(ResourceLocation id, ItemStack icon) {
        BaseTaskJS.Builder builder = new BaseTaskJS.Builder(id, icon);
        this.tasks.add(new BaseTaskJS(builder));
        return builder;
    }

    @Info(value="Creates a new melee task builder, you generally only need to modify weapon checks, extra attack, etc. <br>\n\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u8fd1\u6218\u4efb\u52a1\u6784\u5efa\u5668\uff0c\u4f60\u4e00\u822c\u53ea\u9700\u8981\u4fee\u6539\u6b66\u5668\u5224\u65ad\u3001\u989d\u5916\u653b\u51fb\u7b49\u5185\u5bb9\u5373\u53ef\n", params={@Param(name="id", value="The unique identifier for the task. <br>\n\u4efb\u52a1\u7684 ID\n"), @Param(name="icon", value="use an item to represent the task icon <br>\n\u7528\u7269\u54c1\u6765\u8868\u793a\u4efb\u52a1\u7684\u56fe\u6807\n")})
    public MeleeTaskJS.Builder meleeTask(ResourceLocation id, ItemStack icon) {
        MeleeTaskJS.Builder builder = new MeleeTaskJS.Builder(id, icon);
        this.tasks.add(new MeleeTaskJS(builder));
        return builder;
    }

    @Info(value="Creates a new ranged attack task builder, you generally only need to modify weapon checks, add custom ranged attack logic, etc. <br>\n\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u8fdc\u7a0b\u653b\u51fb\u4efb\u52a1\u6784\u5efa\u5668\uff0c\u4f60\u4e00\u822c\u53ea\u9700\u8981\u4fee\u6539\u6b66\u5668\u5224\u65ad\uff0c\u6dfb\u52a0\u81ea\u5b9a\u4e49\u7684\u8fdc\u7a0b\u653b\u51fb\u903b\u8f91\u7b49\u5185\u5bb9\u5373\u53ef\n", params={@Param(name="id", value="The unique identifier for the task. <br>\n\u4efb\u52a1\u7684 ID\n"), @Param(name="icon", value="use an item to represent the task icon <br>\n\u7528\u7269\u54c1\u6765\u8868\u793a\u4efb\u52a1\u7684\u56fe\u6807\n")})
    public RangedAttackTaskJS.Builder rangedAttackTask(ResourceLocation id, ItemStack icon) {
        RangedAttackTaskJS.Builder builder = new RangedAttackTaskJS.Builder(id, icon);
        this.tasks.add(new RangedAttackTaskJS(builder));
        return builder;
    }

    @Info(value="Creates a new farm task builder, you need to add farming logic such as planting, harvesting, and other content. <br>\n\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u79cd\u7530\u4efb\u52a1\u6784\u5efa\u5668\uff0c\u4f60\u9700\u8981\u6dfb\u52a0\u79cd\u7530\u7684\u903b\u8f91\uff0c\u6bd4\u5982\u79cd\u690d\u3001\u6536\u5272\u7b49\u8bf8\u591a\u5185\u5bb9\n", params={@Param(name="id", value="The unique identifier for the task. <br>\n\u4efb\u52a1\u7684 ID\n"), @Param(name="icon", value="use an item to represent the task icon <br>\n\u7528\u7269\u54c1\u6765\u8868\u793a\u4efb\u52a1\u7684\u56fe\u6807\n")})
    public FarmTaskJS.Builder farmTask(ResourceLocation id, ItemStack icon) {
        FarmTaskJS.Builder builder = new FarmTaskJS.Builder(id, icon);
        this.tasks.add(new FarmTaskJS(builder));
        return builder;
    }

    @Info(value="Creates a new walk to block task builder, you need to add logic such as start condition, searching for blocks, arriving at blocks, etc. <br>\n\u521b\u5efa\u4e00\u4e2a\u8d70\u5411\u76ee\u6807\u65b9\u5757\u7684\u4efb\u52a1\u6784\u5efa\u5668\uff0c\u4f60\u9700\u8981\u5b9a\u4e49\u8d77\u59cb\u6761\u4ef6\u3001\u65b9\u5757\u641c\u7d22\u5224\u65ad\u3001\u5230\u8fbe\u76ee\u6807\u65b9\u5757\u540e\u7684\u884c\u4e3a\u7b49\u5185\u5bb9\u3002\n", params={@Param(name="id", value="The unique identifier for the task. <br>\n\u4efb\u52a1\u7684 ID\n"), @Param(name="icon", value="use an item to represent the task icon <br>\n\u7528\u7269\u54c1\u6765\u8868\u793a\u4efb\u52a1\u7684\u56fe\u6807\n")})
    public WalkToBlockTaskJS.Builder walkToBlockTask(ResourceLocation id, ItemStack icon) {
        WalkToBlockTaskJS.Builder builder = new WalkToBlockTaskJS.Builder(id, icon);
        this.tasks.add(new WalkToBlockTaskJS(builder));
        return builder;
    }

    @Info(value="Creates a new walk to living entity task builder, you need to add logic such as start condition, searching for entities, arriving at entities, etc. <br>\n\u521b\u5efa\u4e00\u4e2a\u8d70\u5411\u76ee\u6807\u751f\u7269\u7684\u4efb\u52a1\u6784\u5efa\u5668\uff0c\u4f60\u9700\u8981\u5b9a\u4e49\u8d77\u59cb\u6761\u4ef6\u3001\u5b9e\u4f53\u641c\u7d22\u5224\u65ad\u3001\u5230\u8fbe\u76ee\u6807\u5b9e\u4f53\u540e\u7684\u884c\u4e3a\u7b49\u5185\u5bb9\u3002\n", params={@Param(name="id", value="The unique identifier for the task. <br>\n\u4efb\u52a1\u7684 ID\n"), @Param(name="icon", value="use an item to represent the task icon <br>\n\u7528\u7269\u54c1\u6765\u8868\u793a\u4efb\u52a1\u7684\u56fe\u6807\n")})
    public WalkToLivingEntityTaskJS.Builder walkToLivingEntityTask(ResourceLocation id, ItemStack icon) {
        WalkToLivingEntityTaskJS.Builder builder = new WalkToLivingEntityTaskJS.Builder(id, icon);
        this.tasks.add(new WalkToLivingEntityTaskJS(builder));
        return builder;
    }

    @HideFromJS
    public void register(TaskManager manager) {
        HashSet existingTasks = Sets.newHashSet();
        for (IMaidTask task : this.tasks) {
            ResourceLocation uid = task.getUid();
            if (existingTasks.contains(uid)) continue;
            existingTasks.add(uid);
            manager.add(task);
        }
        this.tasks.clear();
    }
}

