/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.recipe;

import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCraftingHelper;
import com.google.gson.JsonParseException;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public final class AltarOutputJS {
    @Info(value="Converting KubeJS' Item object to the altar's' output item object", params={@Param(name="stack", value="The ItemStack to convert to an altar output item.")})
    public static EntityCraftingHelper.Output item(ItemStack stack) {
        EntityType item = EntityType.f_20461_;
        CompoundTag data = new CompoundTag();
        data.m_128365_("Item", (Tag)stack.m_41739_(new CompoundTag()));
        return new EntityCraftingHelper.Output(item, data);
    }

    @Info(value="Directly converting an entity ID and extra NBT data to the altar's output entity object", params={@Param(name="entityId", value="The ID of the entity type to output."), @Param(name="data", value="Additional NBT data to attach to the entity.")})
    public static EntityCraftingHelper.Output entity(String entityId, CompoundTag data) {
        EntityType value = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityId));
        if (value == null) {
            throw new JsonParseException("Entity Type Not Found: " + entityId);
        }
        return new EntityCraftingHelper.Output(value, data);
    }

    @Info(value="Directly converting an entity ID to the altar's output entity object with empty NBT data", params={@Param(name="entityId", value="The ID of the entity type to output.")})
    public static EntityCraftingHelper.Output entity(String entityId) {
        return AltarOutputJS.entity(entityId, new CompoundTag());
    }

    @Info(value="Spawn a new maid with a cake box")
    public static EntityCraftingHelper.Output spawnMaidWithBox() {
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)InitEntities.MAID.get()));
        if (key == null) {
            throw new JsonParseException("Maid Entity Type Not Found");
        }
        CompoundTag data = new CompoundTag();
        ListTag passengers = new ListTag();
        CompoundTag maid = new CompoundTag();
        maid.m_128359_("id", key.toString());
        passengers.add((Object)maid);
        data.m_128365_("Passengers", (Tag)passengers);
        return new EntityCraftingHelper.Output((EntityType)InitEntities.BOX.get(), data);
    }

    @Info(value="Reborn the maid from film, the ingredient must have a film")
    public static EntityCraftingHelper.Output rebornMaid() {
        return new EntityCraftingHelper.Output((EntityType)InitEntities.MAID.get(), new CompoundTag(), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)InitItems.FILM.get()}), "MaidInfo");
    }
}

