/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.jmc;

import com.github.tartaricacid.touhoulittlemaid.api.block.IMaidEdibleBlock;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagBlock;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagItem;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.BaseThreeTieredCakeBlock;
import einstein.jmc.block.cake.candle.BaseThreeTieredCandleCakeBlock;
import einstein.jmc.data.SerializableMobEffectInstance;
import einstein.jmc.data.effects.CakeEffects;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModCommonConfigs;
import einstein.jmc.registration.family.CakeFamily;
import einstein.jmc.util.CakeUtil;
import einstein.jmc.util.Util;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class JmcEdible
implements IMaidEdibleBlock {
    private static final TagKey<Block> BLOCK_JMC_CAKES = TagBlock.createTagKey(new ResourceLocation("jmc", "cakes"));
    private static final TagKey<Item> ITEM_JMC_CAKES = TagItem.createTagKey(new ResourceLocation("jmc", "cakes"));

    @Override
    public boolean shouldMoveTo(EntityMaid maid, BlockPos pos, BlockState state) {
        if (state.m_204336_(BLOCK_JMC_CAKES)) {
            return IMaidEdibleBlock.belowIsSnackStand(maid, pos);
        }
        return false;
    }

    @Override
    public int getFavorabilityPoints(EntityMaid maid, BlockPos pos, BlockState state) {
        return 1;
    }

    @Override
    public boolean consume(EntityMaid maid, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (!(block instanceof BaseCakeBlock)) {
            return false;
        }
        BaseCakeBlock baseCake = (BaseCakeBlock)block;
        if (!baseCake.hasBites()) {
            maid.m_6469_(maid.m_269291_().m_269264_(), 2.0f);
            maid.m_216990_(SoundEvents.f_11912_);
            return false;
        }
        Level level = maid.f_19853_;
        EnumProperty half = BaseThreeTieredCandleCakeBlock.HALF;
        if (baseCake instanceof BaseThreeTieredCakeBlock) {
            BlockPos above;
            BlockState aboveState;
            BaseThreeTieredCakeBlock threeTieredCake = (BaseThreeTieredCakeBlock)baseCake;
            if (state.m_61143_((Property)half) == DoubleBlockHalf.LOWER && (aboveState = level.m_8055_(above = pos.m_7494_())).m_60713_((Block)threeTieredCake) && aboveState.m_61143_((Property)half) == DoubleBlockHalf.UPPER) {
                IntegerProperty property = threeTieredCake.getBites();
                if ((Integer)aboveState.m_61143_((Property)property) >= 4) {
                    aboveState = (BlockState)aboveState.m_61124_((Property)property, (Comparable)Integer.valueOf(threeTieredCake.getSlices()));
                }
                this.eatCake(maid, above, aboveState, baseCake);
                return true;
            }
        }
        this.eatCake(maid, pos, state, baseCake);
        return true;
    }

    private void eatCake(EntityMaid maid, BlockPos pos, BlockState state, BaseCakeBlock baseCake) {
        Level level = maid.f_19853_;
        ItemStack stack = baseCake.m_7397_((BlockGetter)level, pos, state);
        int maxBites = baseCake.getSlices();
        IntegerProperty bitesProperty = Objects.requireNonNull(baseCake.getBites());
        int bites = (Integer)state.m_61143_((Property)bitesProperty);
        if (CakeUtil.inFamily((BlockState)state, (CakeFamily)ModBlocks.FIREY_CAKE_FAMILY)) {
            maid.m_20254_((Integer)ModCommonConfigs.FIREY_CAKE_ON_FIRE_DUR.get());
        } else if (CakeUtil.inFamily((BlockState)state, (CakeFamily)ModBlocks.ICE_CAKE_FAMILY)) {
            maid.m_20095_();
        } else if (CakeUtil.inFamily((BlockState)state, (CakeFamily)ModBlocks.CHORUS_CAKE_FAMILY)) {
            maid.m_216990_(SoundEvents.f_11852_);
            Util.teleportRandomly((LivingEntity)maid, (double)((Double)ModCommonConfigs.CHORUS_CAKE_TELEPORT_RADIUS.get()));
            maid.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        } else if (CakeUtil.inFamily((BlockState)state, (CakeFamily)ModBlocks.ENDER_CAKE_FAMILY)) {
            Util.teleportRandomly((LivingEntity)maid, (double)((Double)ModCommonConfigs.ENDER_CAKE_TELEPORT_RADIUS.get()));
            maid.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        CakeEffects effects = baseCake.justMoreCakes$getCakeEffects();
        if (effects != null) {
            for (SerializableMobEffectInstance effectInstance : effects.mobEffects()) {
                Util.applyEffectFromInstance((SerializableMobEffectInstance)effectInstance, (LivingEntity)maid);
            }
        }
        if (bites < maxBites) {
            int currentBites = Math.min(bites + 1, maxBites);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)bitesProperty, (Comparable)Integer.valueOf(currentBites)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        maid.m_21060_(stack, 8);
        maid.m_216990_(SoundEvents.f_11912_);
    }

    @Override
    public boolean canPlaceAsFood(EntityMaid maid, ItemStack stack, int slotIndex) {
        return stack.m_204117_(ITEM_JMC_CAKES);
    }
}

