/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.immersivemelodies;

import com.github.tartaricacid.touhoulittlemaid.client.animation.HardcodedAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.molang.CtrlBinding;
import com.github.tartaricacid.touhoulittlemaid.compat.immersivemelodies.CompatAnimation;
import com.github.tartaricacid.touhoulittlemaid.compat.immersivemelodies.ImmersiveMelodiesCompatInner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.ModList;

public class ImmersiveMelodiesCompat {
    private static final String IMMERSIVE_MELODIES = "immersive_melodies";
    private static boolean IS_LOADED = false;

    public static void init() {
        IS_LOADED = ModList.get().isLoaded(IMMERSIVE_MELODIES);
    }

    public static void addAnimation(HardcodedAnimationManger manger) {
        if (IS_LOADED) {
            manger.addMaidAnimation(new CompatAnimation());
        }
    }

    public static void updateMelodyProgress(LivingEntity entity, ImmersiveMelodiesData imData) {
        if (IS_LOADED) {
            ImmersiveMelodiesCompatInner.updateMelodyProgress(entity, imData);
        }
    }

    public static void addBinding(CtrlBinding binding) {
        if (IS_LOADED) {
            ImmersiveMelodiesCompatInner.addInnerBinding(binding);
        } else {
            ImmersiveMelodiesCompat.addEmptyBinding(binding);
        }
    }

    private static void addEmptyBinding(CtrlBinding binding) {
        binding.livingEntityVar("im_pitch", ctx -> Float.valueOf(0.0f));
        binding.livingEntityVar("im_volume", ctx -> Float.valueOf(0.0f));
        binding.livingEntityVar("im_current", ctx -> Float.valueOf(0.0f));
        binding.livingEntityVar("im_delta", ctx -> 0L);
        binding.livingEntityVar("im_time", ctx -> 0L);
    }

    public static final class ImmersiveMelodiesData {
        public float pitch = 0.0f;
        public float volume = 0.0f;
        public float current = 0.0f;
        public long delta = 0L;
        public long time = 0L;
    }
}

