/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare;

import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.entity.projectile.RgoGrenadeEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.HandGrenade;
import com.atsuishio.superbwarfare.item.RgoGrenade;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidAnimationMessage;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SWarfareCompatInner {
    static boolean isGun(ItemStack stack) {
        return stack.m_41720_() instanceof GunItem;
    }

    static boolean isGrenade(ItemStack stack) {
        return stack.m_41720_() instanceof HandGrenade;
    }

    static boolean isVehicle(Entity entity) {
        return entity instanceof VehicleEntity;
    }

    static boolean shouldHideLivingRender(LivingEntity maid) {
        Entity entity = maid.m_20202_();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            return vehicle.hidePassenger((Entity)maid);
        }
        return false;
    }

    static boolean canSee(EntityMaid maid, LivingEntity target) {
        ItemStack handItem = maid.m_21205_();
        if (!(handItem.m_41720_() instanceof GunItem)) {
            return BehaviorUtils.m_22667_((LivingEntity)maid, (LivingEntity)target);
        }
        GunData gunData = GunData.from((ItemStack)handItem);
        if (gunData == null) {
            return maid.canSee(target);
        }
        if (handItem.m_204117_(SWarfareCompat.SNIPER)) {
            return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
        }
        if (handItem.m_204117_(SWarfareCompat.PISTOL) || handItem.m_204117_(SWarfareCompat.SMG) || handItem.m_204117_(SWarfareCompat.SHOOTGUN)) {
            return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_NEAR_DISTANCE);
        }
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_MEDIUM_DISTANCE);
    }

    static Optional<Boolean> canVehicleSee(EntityMaid maid, LivingEntity target) {
        Player player;
        Entity playerVehicle;
        Entity vehicle = maid.m_20202_();
        if (vehicle != null && SWarfareCompat.isVehicle(vehicle)) {
            boolean canSee = IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
            return Optional.of(canSee);
        }
        LivingEntity owner = maid.m_269323_();
        if (owner instanceof Player && (playerVehicle = (player = (Player)owner).m_20202_()) != null && playerVehicle.m_20197_().contains(maid) && SWarfareCompat.isVehicle(playerVehicle)) {
            boolean canSee = IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
            return Optional.of(canSee);
        }
        return Optional.empty();
    }

    static void tick(EntityMaid shooter, LivingEntity target, ItemStack gunItem) {
        if (!(gunItem.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData gunData = GunData.from((ItemStack)gunItem);
        if (gunData == null) {
            return;
        }
        gunData.tick((Entity)shooter, true);
    }

    static void onStop(EntityMaid maid, GunShootTargetTask task) {
        ItemStack offhand = maid.m_21206_();
        if (offhand.m_41720_() instanceof RgoGrenade) {
            task.setAttackCooldown(50);
        }
    }

    static int performGunAttack(EntityMaid shooter, LivingEntity target, ItemStack gunItem) {
        if (!(gunItem.m_41720_() instanceof GunItem)) {
            return 100;
        }
        GunData gunData = GunData.from((ItemStack)gunItem);
        if (gunData == null) {
            return 100;
        }
        int result = SWarfareCompatInner.doGunReload(shooter, gunData);
        if (result > 0) {
            return result;
        }
        if (!gunData.canShoot((Entity)shooter)) {
            SWarfareCompatInner.useGrenade(shooter, target);
            return 50;
        }
        return SWarfareCompatInner.doGunShoot(shooter, target, gunItem, gunData);
    }

    private static void useGrenade(EntityMaid shooter, LivingEntity target) {
        ItemStack offhand = shooter.m_21206_();
        if (offhand.m_41720_() instanceof RgoGrenade && shooter.m_20270_((Entity)target) <= 16.0f) {
            SWarfareCompatInner.setViewRot(shooter, target);
            float power = 1.2f + shooter.m_217043_().m_188501_() * 0.4f;
            RgoGrenadeEntity rgoGrenade = new RgoGrenadeEntity((LivingEntity)shooter, shooter.f_19853_, 40);
            rgoGrenade.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, power, 0.0f);
            shooter.f_19853_.m_7967_((Entity)rgoGrenade);
            shooter.f_19853_.m_5594_(null, shooter.m_20183_(), (SoundEvent)ModSounds.GRENADE_THROW.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            offhand.m_41774_(1);
        }
    }

    private static int doGunReload(EntityMaid shooter, GunData gunData) {
        if (gunData.shouldStartReloading((Entity)shooter)) {
            gunData.startReload();
            MaidAnimationMessage msg = new MaidAnimationMessage(shooter.m_19879_(), 3);
            NetworkHandler.sendToTrackingEntity(msg, (Entity)shooter);
            return 5;
        }
        if (gunData.shouldStartBolt()) {
            gunData.startBolt();
            MaidAnimationMessage msg = new MaidAnimationMessage(shooter.m_19879_(), 3);
            NetworkHandler.sendToTrackingEntity(msg, (Entity)shooter);
            return 5;
        }
        return -1;
    }

    private static int doGunShoot(EntityMaid shooter, LivingEntity target, ItemStack gunItem, GunData gunData) {
        boolean isSniper = gunItem.m_204117_(SWarfareCompat.SNIPER);
        if (isSniper && !shooter.isAiming()) {
            shooter.setAiming(true);
            return 20;
        }
        if (!isSniper) {
            float radius;
            float distance = shooter.m_20270_((Entity)target);
            if (distance <= (radius = shooter.m_21535_()) && shooter.isAiming()) {
                shooter.setAiming(false);
                return 10;
            }
            if (distance > radius && !shooter.isAiming()) {
                shooter.setAiming(true);
                return 20;
            }
        }
        double rps = (double)((Integer)gunData.get(GunProp.RPM)).intValue() / 60.0;
        int cooldown = (int)Math.round(20.0 / rps);
        FireMode fireMode = (FireMode)gunData.fireMode.get();
        if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST && gunData.burstAmount.get() == 0) {
            cooldown += 5 + shooter.m_217043_().m_188503_(5);
        }
        SWarfareCompatInner.setViewRot(shooter, target);
        gunData.shoot((Entity)shooter, 0.0, shooter.isAiming(), target.m_20148_());
        MaidAnimationMessage msg = new MaidAnimationMessage(shooter.m_19879_(), 4);
        NetworkHandler.sendToTrackingEntity(msg, (Entity)shooter);
        return cooldown;
    }

    private static void setViewRot(EntityMaid shooter, LivingEntity target) {
        double x = target.m_20185_() - shooter.m_20185_();
        double y = target.m_20188_() - shooter.m_20188_();
        double z = target.m_20189_() - shooter.m_20189_();
        float yaw = (float)(-Math.toDegrees(Math.atan2(x, z)));
        float pitch = (float)(-Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z))));
        shooter.m_146926_(pitch);
        shooter.m_146922_(yaw);
    }
}

