/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.farmersdelight;

import com.github.tartaricacid.touhoulittlemaid.api.block.IMaidEdibleBlock;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class FarmersDelightEdible
implements IMaidEdibleBlock {
    @Override
    public boolean shouldMoveTo(EntityMaid maid, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof PieBlock || block instanceof FeastBlock) {
            return IMaidEdibleBlock.belowIsSnackStand(maid, pos);
        }
        return false;
    }

    @Override
    public int getFavorabilityPoints(EntityMaid maid, BlockPos pos, BlockState state) {
        return 1;
    }

    @Override
    public boolean consume(EntityMaid maid, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        Level level = maid.f_19853_;
        ItemStack stack = block.m_7397_((BlockGetter)level, pos, state);
        if (block instanceof PieBlock) {
            int maxBites;
            PieBlock pieBlock = (PieBlock)block;
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            if (bites < (maxBites = pieBlock.getMaxBites() - 1)) {
                int currentBites = Math.min(bites + 1, maxBites);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)PieBlock.BITES, (Comparable)Integer.valueOf(currentBites)), 3);
            } else {
                maid.destroyBlock(pos);
            }
        } else if (block instanceof FeastBlock) {
            FeastBlock feastBlock = (FeastBlock)block;
            IntegerProperty property = feastBlock.getServingsProperty();
            int servings = (Integer)state.m_61143_((Property)property);
            if (0 < servings) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)property, (Comparable)Integer.valueOf(servings - 1)), 3);
            } else {
                maid.destroyBlock(pos);
            }
        }
        maid.m_21060_(stack, 8);
        maid.m_216990_(SoundEvents.f_11912_);
        return true;
    }

    @Override
    public boolean canPlaceAsFood(EntityMaid maid, ItemStack stack, int slotIndex) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            return block instanceof PieBlock || block instanceof FeastBlock;
        }
        return false;
    }
}

