/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.curios.menu;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.ITriggerSlotChange;
import com.github.tartaricacid.touhoulittlemaid.compat.curios.menu.MaidCurioSlot;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.CuriosS2CUpdateMessage;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosContainer
extends MaidMainContainer {
    public static final MenuType<CuriosContainer> TYPE = IForgeMenuType.create((windowId, inv, data) -> new CuriosContainer(windowId, inv, data.readInt()));
    private static final int PREV = 0;
    private static final int NEXT = 1;
    private static final int SLOTS_PER_PAGE = 36;
    private final LazyOptional<ICuriosItemHandler> curiosHandler;
    private int maxPages;
    private int page;

    public CuriosContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        this.curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)this.maid);
        int curiosSlotsCount = this.curiosHandler.map(ICuriosItemHandler::getVisibleSlots).orElse(0);
        this.maxPages = (curiosSlotsCount - 1) / 36;
        this.page = Math.min(this.page, this.maxPages);
        if (this.maid != null) {
            this.curiosHandler.ifPresent(this::addCuriosSlotsForPage);
        }
    }

    public static MenuProvider create(final EntityMaid maid) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Curios Container");
            }

            public AbstractContainerMenu m_7208_(int index, Inventory inventory, Player player) {
                int entityId = maid.m_19879_();
                return new CuriosContainer(index, inventory, entityId);
            }
        };
    }

    public boolean m_6366_(Player player, int id) {
        if (player instanceof ServerPlayer) {
            if (id == 0 && this.page > 0) {
                this.updatePage(this.page - 1, player);
                return true;
            }
            if (id == 1 && this.page < this.maxPages) {
                this.updatePage(this.page + 1, player);
                return true;
            }
        }
        return true;
    }

    public void updatePage(int page, Player player) {
        int curiosSlotsCount = this.curiosHandler.map(ICuriosItemHandler::getVisibleSlots).orElse(0);
        this.maxPages = (curiosSlotsCount - 1) / 36;
        this.page = Math.min(page, this.maxPages);
        this.curiosHandler.ifPresent(handler -> {
            this.f_38839_.clear();
            this.f_38841_.clear();
            this.f_150394_.clear();
            this.addPlayerInv(player.m_150109_());
            this.addMaidArmorInv();
            this.addMaidHandInv();
            this.addCuriosSlotsForPage((ICuriosItemHandler)handler);
        });
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToClientPlayer(new CuriosS2CUpdateMessage(this.page), (Player)serverPlayer);
        }
    }

    public void resetPage(Player player) {
        this.updatePage(this.page, player);
    }

    @Override
    protected void addMainDefaultInv() {
    }

    @Override
    protected void addBackpackInv(Inventory inventory) {
    }

    public void m_182406_(int slotId, int pStateId, ItemStack pStack) {
        if (slotId < this.f_38839_.size()) {
            super.m_182406_(slotId, pStateId, pStack);
        }
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack1 = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            int baubleSlots;
            ItemStack stack2 = slot.m_7993_();
            stack1 = stack2.m_41777_();
            if (index < 36 ? !this.m_38903_(stack2, baubleSlots = 42, this.f_38839_.size(), false) && !this.m_38903_(stack2, 36, baubleSlots, false) : !this.m_38903_(stack2, 0, 36, true)) {
                return ItemStack.f_41583_;
            }
            if (stack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack2.m_41613_() == stack1.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack2);
            if (slot instanceof ITriggerSlotChange) {
                ITriggerSlotChange slotChange = (ITriggerSlotChange)slot;
                slotChange.onShiftTakeoff(player, stack1);
            }
            if (36 <= index && index < 40) {
                EquipmentSlot equipmentSlot = SLOT_IDS[index - 36];
                this.maid.m_21128_(equipmentSlot, stack1);
            }
            if (40 <= index && index < 42) {
                int slotIndex = index - 36 - 4;
                EquipmentSlot equipmentSlot = slotIndex == 0 ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                this.maid.m_21168_(equipmentSlot, stack1);
            }
        }
        return stack1;
    }

    private void addCuriosSlotsForPage(ICuriosItemHandler curios) {
        int total = 0;
        int start = this.page * 36;
        int end = start + 36;
        for (Map.Entry entry : curios.getCurios().entrySet()) {
            ICurioStacksHandler handler = (ICurioStacksHandler)entry.getValue();
            if (!handler.isVisible()) continue;
            IDynamicStackHandler stacks = handler.getStacks();
            int maxIndex = stacks.getSlots();
            if (total + maxIndex <= start) {
                total += maxIndex;
                continue;
            }
            if (total >= end) {
                return;
            }
            String identifier = (String)entry.getKey();
            for (int i = 0; i < maxIndex && total < end; ++i, ++total) {
                if (total < start) continue;
                int displayIndex = total - start;
                int x = 143 + displayIndex % 6 * 18;
                int y = 37 + displayIndex / 6 * 18;
                this.m_38897_((Slot)new MaidCurioSlot(this.maid, stacks, i, identifier, x, y, (NonNullList<Boolean>)handler.getRenders(), false));
            }
        }
    }
}

