/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.curios.client;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack.IBackpackContainerScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.BaubleButton;
import com.github.tartaricacid.touhoulittlemaid.compat.curios.client.CuriosButton;
import com.github.tartaricacid.touhoulittlemaid.compat.curios.menu.CuriosContainer;
import com.github.tartaricacid.touhoulittlemaid.compat.curios.menu.MaidCurioSlot;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidGuiMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class CuriosContainerScreen
extends AbstractMaidContainerGui<CuriosContainer>
implements IBackpackContainerScreen {
    private static final ResourceLocation CURIOS_BG = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_curios.png");
    private static final int PREV = 0;
    private static final int NEXT = 1;
    private final EntityMaid maid;
    private int maxPages;
    private int maxSlots;
    private int page;
    private int slotCount;

    public CuriosContainerScreen(CuriosContainer container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn);
        this.f_97727_ = 256;
        this.f_97726_ = 256;
        this.maid = ((CuriosContainer)this.f_97732_).getMaid();
        this.maxSlots = CuriosApi.getCuriosInventory((LivingEntity)this.maid).map(ICuriosItemHandler::getVisibleSlots).orElse(0);
        this.maxPages = (this.maxSlots - 1) / 36;
        this.page = Math.min(this.page, this.maxPages);
        this.slotCount = Math.min(this.maxSlots - this.page * 36, 36);
    }

    public void updatePage(int page) {
        this.maxSlots = CuriosApi.getCuriosInventory((LivingEntity)this.maid).map(ICuriosItemHandler::getVisibleSlots).orElse(0);
        this.maxPages = (this.maxSlots - 1) / 36;
        this.page = Math.min(page, this.maxPages);
        this.slotCount = Math.min(this.maxSlots - this.page * 36, 36);
        ((CuriosContainer)this.m_6262_()).updatePage(page, (Player)this.getMinecraft().f_91074_);
        this.m_7856_();
    }

    @Override
    protected void initAdditionWidgets() {
        BaubleButton button = this.getBaubleButton(this.maid, this.f_97735_, this.f_97736_);
        this.m_142416_((GuiEventListener)button);
        CuriosButton curiosButton = new CuriosButton(this.f_97735_, this.f_97736_, true, btn -> {
            OpenMaidGuiMessage message = new OpenMaidGuiMessage(this.maid.m_19879_(), 0);
            NetworkHandler.CHANNEL.sendToServer((Object)message);
        });
        this.m_142416_((GuiEventListener)curiosButton);
        if (this.maxPages > 0) {
            ImageButton prevButton = new ImageButton(this.f_97735_ + 168, this.f_97736_ + 147, 11, 12, 166, 0, 12, CURIOS_BG, b -> {
                MultiPlayerGameMode gameMode = this.getMinecraft().f_91072_;
                if (gameMode != null && this.page > 0) {
                    gameMode.m_105208_(((CuriosContainer)this.f_97732_).f_38840_, 0);
                }
            });
            ImageButton nextButton = new ImageButton(this.f_97735_ + 214, this.f_97736_ + 147, 11, 12, 177, 0, 12, CURIOS_BG, b -> {
                MultiPlayerGameMode gameMode = this.getMinecraft().f_91072_;
                if (gameMode != null && this.page < this.maxPages) {
                    gameMode.m_105208_(((CuriosContainer)this.f_97732_).f_38840_, 1);
                }
            });
            this.m_142416_((GuiEventListener)prevButton);
            this.m_142416_((GuiEventListener)nextButton);
        }
    }

    @Override
    protected void renderAddition(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.maxPages > 0) {
            MutableComponent page = Component.m_237113_((String)"%d/%d".formatted(this.page + 1, this.maxPages + 1));
            int width = this.f_96547_.m_92852_((FormattedText)page);
            graphics.m_280614_(this.f_96547_, (Component)page, this.f_97735_ + 197 - width / 2, this.f_97736_ + 150, 0x555555, false);
        } else {
            MutableComponent name = Component.m_237115_((String)"curios.name");
            int width = this.f_96547_.m_92852_((FormattedText)name);
            graphics.m_280614_(this.f_96547_, (Component)name, this.f_97735_ + 197 - width / 2, this.f_97736_ + 150, 0x555555, false);
        }
    }

    @Override
    protected void renderAdditionTransTooltip(GuiGraphics graphics, int x, int y) {
        Slot slot;
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer != null && clientPlayer.f_36095_.m_142621_().m_41619_() && this.getSlotUnderMouse() != null && (slot = this.getSlotUnderMouse()) instanceof MaidCurioSlot) {
            MaidCurioSlot slotCurio = (MaidCurioSlot)slot;
            if (!slot.m_6657_()) {
                MutableComponent name = Component.m_237113_((String)slotCurio.getSlotName());
                graphics.m_280557_(this.f_96547_, (Component)name, x, y);
            }
        }
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CURIOS_BG);
        graphics.m_280218_(CURIOS_BG, this.f_97735_ + 85, this.f_97736_ + 36, 0, 0, 57, 58);
        if (this.slotCount > 0) {
            int rows = (this.slotCount - 1) / 6;
            int width = (this.slotCount - 1) % 6 * 18 + 18;
            if (rows > 0) {
                int height = rows * 18;
                graphics.m_280218_(CURIOS_BG, this.f_97735_ + 142, this.f_97736_ + 36, 57, 0, 108, height);
                graphics.m_280218_(CURIOS_BG, this.f_97735_ + 142, this.f_97736_ + 36 + height, 57, height, width, 18);
            } else {
                graphics.m_280218_(CURIOS_BG, this.f_97735_ + 142, this.f_97736_ + 36, 57, 0, width, 18);
            }
        }
    }

    public int getPage() {
        return this.page;
    }
}

