/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.item.ItemCamera;
import com.github.tartaricacid.touhoulittlemaid.world.backups.MaidBackupsManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class BackupCommand {
    private static final String BACKUP_NAME = "backup";
    private static final String GET_NAME = "get";
    private static final String PLAYER_NAME = "player";
    private static final String MAID_UUID = "maid_uuid";
    private static final String FILE_NAME = "file_name";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder root = Commands.m_82127_((String)BACKUP_NAME);
        LiteralArgumentBuilder get = Commands.m_82127_((String)GET_NAME);
        RequiredArgumentBuilder player = Commands.m_82129_((String)PLAYER_NAME, (ArgumentType)EntityArgument.m_91466_());
        RequiredArgumentBuilder maidUuid = Commands.m_82129_((String)MAID_UUID, (ArgumentType)UuidArgument.m_113850_());
        RequiredArgumentBuilder fileName = Commands.m_82129_((String)FILE_NAME, (ArgumentType)StringArgumentType.string());
        root.then(get.then(player.executes(BackupCommand::handlePlayerMaidIndex)));
        root.then(get.then(player.then(maidUuid.executes(BackupCommand::handlePlayerMaid))));
        root.then(get.then(player.then(maidUuid.then(fileName.executes(BackupCommand::handlePlayerMaidFile)))));
        return root;
    }

    private static String getFormattedTime(long timestamp) {
        LocalDateTime dateTime = LocalDateTime.ofEpochSecond(timestamp / 1000L, 0, ZoneOffset.UTC);
        return dateTime.format(DateTimeFormatter.ofPattern("(MM/dd HH:mm)"));
    }

    private static int handlePlayerMaidIndex(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)PLAYER_NAME);
        Map maidIndexMap = MaidBackupsManager.getMaidIndexMap(player);
        if (maidIndexMap.isEmpty()) {
            MutableComponent error = Component.m_237110_((String)"message.touhou_little_maid.maid_backup.player.no_data", (Object[])new Object[]{player.m_6302_()});
            player.m_213846_((Component)error.m_130940_(ChatFormatting.RED));
            return 1;
        }
        maidIndexMap = maidIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingLong(MaidBackupsManager.IndexData::timestamp).reversed())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        MutableComponent separator = Component.m_237110_((String)"message.touhou_little_maid.maid_backup.player.separator", (Object[])new Object[]{player.m_6302_()});
        player.m_213846_((Component)separator.m_130940_(ChatFormatting.DARK_GREEN));
        int index = 1;
        for (Map.Entry entry : maidIndexMap.entrySet()) {
            UUID id = (UUID)entry.getKey();
            MaidBackupsManager.IndexData data = (MaidBackupsManager.IndexData)entry.getValue();
            String time = "\u00a77" + BackupCommand.getFormattedTime(data.timestamp());
            MutableComponent msg = Component.m_237113_((String)"\u00a77%d.".formatted(index)).m_7220_(CommonComponents.f_263701_).m_7220_(data.name()).m_130940_(ChatFormatting.GOLD).m_7220_(CommonComponents.f_263701_).m_130946_(time);
            MutableComponent dimension = Component.m_237110_((String)"tooltips.touhou_little_maid.fox_scroll.dimension", (Object[])new Object[]{data.dimension()});
            MutableComponent pos = Component.m_237110_((String)"tooltips.touhou_little_maid.fox_scroll.position", (Object[])new Object[]{data.pos().m_123344_()});
            String command = "/tlm backup get @s %s".formatted(id);
            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)CommonComponents.m_178396_((Component[])new Component[]{dimension, pos}));
            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
            msg.m_130938_(style -> style.m_131144_(hoverEvent)).m_130938_(style -> style.m_131142_(clickEvent));
            player.m_213846_((Component)msg);
            ++index;
        }
        return 1;
    }

    private static int handlePlayerMaid(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)PLAYER_NAME);
        UUID uuid = UuidArgument.m_113853_(context, (String)MAID_UUID);
        Map<UUID, MaidBackupsManager.IndexData> maidIndexMap = MaidBackupsManager.getMaidIndexMap(player);
        MaidBackupsManager.IndexData indexData = maidIndexMap.get(uuid);
        if (indexData == null) {
            MutableComponent error = Component.m_237110_((String)"message.touhou_little_maid.maid_backup.maid.not_found", (Object[])new Object[]{uuid});
            player.m_213846_((Component)error.m_130940_(ChatFormatting.RED));
            return 1;
        }
        MutableComponent separator = Component.m_237110_((String)"message.touhou_little_maid.maid_backup.maid.separator", (Object[])new Object[]{indexData.name()});
        player.m_213846_((Component)separator.m_130940_(ChatFormatting.DARK_GREEN));
        List<String> backupFiles = MaidBackupsManager.getMaidBackupFiles(player, uuid);
        for (String backupFile : backupFiles) {
            MutableComponent msg = Component.m_237113_((String)backupFile).m_130940_(ChatFormatting.DARK_PURPLE);
            String command = "/tlm backup get @s %s \"%s\"".formatted(uuid, backupFile);
            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
            msg.m_130938_(style -> style.m_131142_(clickEvent));
            player.m_213846_((Component)msg);
        }
        return 1;
    }

    private static int handlePlayerMaidFile(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String fileName;
        UUID uuid;
        ServerPlayer player = EntityArgument.m_91474_(context, (String)PLAYER_NAME);
        CompoundTag backupData = MaidBackupsManager.getMaidBackFile(player, uuid = UuidArgument.m_113853_(context, (String)MAID_UUID), fileName = StringArgumentType.getString(context, (String)FILE_NAME));
        if (backupData.m_128456_()) {
            MutableComponent error = Component.m_237110_((String)"message.touhou_little_maid.maid_backup.file.not_found", (Object[])new Object[]{fileName});
            player.m_213846_((Component)error.m_130940_(ChatFormatting.RED));
            return 1;
        }
        ItemCamera.spawnMaidPhoto(player.f_19853_, backupData, (Player)player);
        MutableComponent success = Component.m_237110_((String)"message.touhou_little_maid.maid_backup.file.success", (Object[])new Object[]{fileName});
        player.m_213846_((Component)success.m_130940_(ChatFormatting.GREEN));
        return 1;
    }
}

