/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource;

import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.NotNull;

public class LegacyPackRepositorySource
implements RepositorySource {
    private static final String LEGACY_PACK_DIR_NAME = "legacy_pack";
    private static final String PACK_NAME = "touhou_little_maid_legacy_resources_pack";
    private final Pack legacyPack;

    public LegacyPackRepositorySource() {
        Pack.ResourcesSupplier supplier = name -> this.getLegacyPack();
        MutableComponent desc = Component.m_237115_((String)"pack.touhou_little_maid.legacy_resources_pack.desc");
        int packFormatVersion = SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES);
        Pack.Info info = new Pack.Info((Component)desc, packFormatVersion, FeatureFlagSet.m_246902_());
        MutableComponent title = Component.m_237115_((String)"pack.touhou_little_maid.legacy_resources_pack.title");
        this.legacyPack = Pack.m_245512_((String)PACK_NAME, (Component)title, (boolean)false, (Pack.ResourcesSupplier)supplier, (Pack.Info)info, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_);
    }

    private PathPackResources getLegacyPack() {
        final IModFile file = ModList.get().getModFileById("touhou_little_maid").getFile();
        return new PathPackResources(file.getFileName(), true, file.getFilePath()){

            @NotNull
            protected Path resolve(String ... paths) {
                String[] newPaths = new String[paths.length + 1];
                newPaths[0] = LegacyPackRepositorySource.LEGACY_PACK_DIR_NAME;
                System.arraycopy(paths, 0, newPaths, 1, paths.length);
                return file.findResource(newPaths);
            }
        };
    }

    public void m_7686_(Consumer<Pack> consumer) {
        consumer.accept(this.legacyPack);
    }
}

