/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.event.client.DefaultGeckoAnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionManager;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.Animation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.file.AnimationFile;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.Converter;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.FormatVersion;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.RawGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.tree.RawGeometryTree;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.GeoBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.json.JsonAnimationUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GeckoModelLoader {
    public static final ResourceLocation DEFAULT_MAID_ANIMATION = new ResourceLocation("touhou_little_maid", "animation/maid.animation.json");
    public static final ResourceLocation DEFAULT_TAC_ANIMATION = new ResourceLocation("touhou_little_maid", "animation/tac.animation.json");
    public static final ResourceLocation DEFAULT_CHAIR_ANIMATION = new ResourceLocation("touhou_little_maid", "animation/chair.animation.json");
    public static final ResourceLocation DEFAULT_ISS_ANIMATION = new ResourceLocation("touhou_little_maid", "animation/iss.animation.json");
    public static final ResourceLocation DEFAULT_IM_ANIMATION = new ResourceLocation("touhou_little_maid", "animation/im.animation.json");
    public static AnimationFile DEFAULT_MAID_ANIMATION_FILE = new AnimationFile();
    public static AnimationFile DEFAULT_CHAIR_ANIMATION_FILE = new AnimationFile();
    public static AnimationFile DEFAULT_TAC_ANIMATION_FILE = new AnimationFile();
    public static AnimationFile DEFAULT_ISS_ANIMATION_FILE = new AnimationFile();
    public static AnimationFile DEFAULT_IM_ANIMATION_FILE = new AnimationFile();

    public static void reload() {
        GeckoModelLoader.clearAllCache();
        GeckoModelLoader.loadDefaultAnimation();
    }

    public static void registerGeo(ResourceLocation id, InputStream inputStream) {
        Map<ResourceLocation, GeoModel> geoModels = GeckoLibCache.getInstance().getGeoModels();
        RawGeoModel rawModel = Converter.fromInputStream(inputStream);
        if (rawModel.getFormatVersion() == FormatVersion.NEW) {
            RawGeometryTree rawGeometryTree = RawGeometryTree.parseHierarchy(rawModel);
            GeoModel geoModel = GeoBuilder.getGeoBuilder().constructGeoModel(rawGeometryTree);
            geoModels.put(id, geoModel);
        }
    }

    public static void registerMaidAnimations(ResourceLocation id, AnimationFile animationFile) {
        DEFAULT_MAID_ANIMATION_FILE.animations().forEach((name, action) -> {
            if (!animationFile.animations().containsKey(name)) {
                animationFile.putAnimation((String)name, (Animation)action);
            }
        });
        DEFAULT_TAC_ANIMATION_FILE.animations().forEach((name, action) -> {
            if (!animationFile.animations().containsKey(name)) {
                animationFile.putAnimation((String)name, (Animation)action);
            }
        });
        DEFAULT_ISS_ANIMATION_FILE.animations().forEach((name, action) -> {
            if (!animationFile.animations().containsKey(name)) {
                animationFile.putAnimation((String)name, (Animation)action);
            }
        });
        DEFAULT_IM_ANIMATION_FILE.animations().forEach((name, action) -> {
            if (!animationFile.animations().containsKey(name)) {
                animationFile.putAnimation((String)name, (Animation)action);
            }
        });
        animationFile.animations().forEach((name, animation) -> ConditionManager.addTest(id, name));
        GeckoLibCache.getInstance().getAnimations().put(id, animationFile);
    }

    public static void registerChairAnimations(ResourceLocation id, AnimationFile animationFile) {
        DEFAULT_CHAIR_ANIMATION_FILE.animations().forEach((name, action) -> {
            if (!animationFile.animations().containsKey(name)) {
                animationFile.putAnimation((String)name, (Animation)action);
            }
        });
        animationFile.animations().forEach((name, animation) -> ConditionManager.addTest(id, name));
        GeckoLibCache.getInstance().getAnimations().put(id, animationFile);
    }

    public static void mergeAnimationFile(InputStream inputStream, AnimationFile animationFile) {
        GeckoModelLoader.mergeAnimationFile(animationFile, GeckoModelLoader.getAnimationFile(inputStream));
    }

    private static AnimationFile getAnimationFile(InputStream stream) {
        AnimationFile animationFile = new AnimationFile();
        MolangParser parser = GeckoLibCache.getInstance().parser;
        JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)CustomPackLoader.GSON, (Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry<String, JsonElement> entry : JsonAnimationUtils.getAnimations(jsonObject)) {
            String animationName = entry.getKey();
            try {
                Animation animation = JsonAnimationUtils.deserializeJsonToAnimation(JsonAnimationUtils.getAnimation(jsonObject, animationName), parser);
                animationFile.putAnimation(animationName, animation);
            }
            catch (ChainedJsonException e) {
                TouhouLittleMaid.LOGGER.error("Failed to load animation {}: {}", (Object)animationName, (Object)e.getMessage());
            }
        }
        return animationFile;
    }

    private static AnimationFile mergeAnimationFile(AnimationFile main, AnimationFile other) {
        other.animations().forEach(main::putAnimation);
        return main;
    }

    private static void clearAllCache() {
        GeckoLibCache.getInstance().getGeoModels().clear();
    }

    private static void loadDefaultAnimation() {
        InputStream stream;
        try {
            stream = Minecraft.m_91087_().m_91098_().m_215595_(DEFAULT_MAID_ANIMATION);
            try {
                DEFAULT_MAID_ANIMATION_FILE = GeckoModelLoader.getAnimationFile(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to load default maid animation file:", (Throwable)e);
        }
        try {
            stream = Minecraft.m_91087_().m_91098_().m_215595_(DEFAULT_CHAIR_ANIMATION);
            try {
                DEFAULT_CHAIR_ANIMATION_FILE = GeckoModelLoader.getAnimationFile(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to load default chair animation file:", (Throwable)e);
        }
        try {
            stream = Minecraft.m_91087_().m_91098_().m_215595_(DEFAULT_TAC_ANIMATION);
            try {
                DEFAULT_TAC_ANIMATION_FILE = GeckoModelLoader.getAnimationFile(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to load default tac animation file:", (Throwable)e);
        }
        try {
            stream = Minecraft.m_91087_().m_91098_().m_215595_(DEFAULT_ISS_ANIMATION);
            try {
                DEFAULT_ISS_ANIMATION_FILE = GeckoModelLoader.getAnimationFile(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to load default iss animation file:", (Throwable)e);
        }
        try {
            stream = Minecraft.m_91087_().m_91098_().m_215595_(DEFAULT_IM_ANIMATION);
            try {
                DEFAULT_IM_ANIMATION_FILE = GeckoModelLoader.getAnimationFile(stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to load default im animation file:", (Throwable)e);
        }
        EnumMap<DefaultGeckoAnimationEvent.AnimationType, AnimationFile> animationFiles = new EnumMap<DefaultGeckoAnimationEvent.AnimationType, AnimationFile>(DefaultGeckoAnimationEvent.AnimationType.class);
        animationFiles.put(DefaultGeckoAnimationEvent.AnimationType.MAID, DEFAULT_MAID_ANIMATION_FILE);
        animationFiles.put(DefaultGeckoAnimationEvent.AnimationType.CHAIR, DEFAULT_CHAIR_ANIMATION_FILE);
        animationFiles.put(DefaultGeckoAnimationEvent.AnimationType.TAC, DEFAULT_TAC_ANIMATION_FILE);
        animationFiles.put(DefaultGeckoAnimationEvent.AnimationType.ISS, DEFAULT_ISS_ANIMATION_FILE);
        animationFiles.put(DefaultGeckoAnimationEvent.AnimationType.IM, DEFAULT_IM_ANIMATION_FILE);
        MinecraftForge.EVENT_BUS.post((Event)new DefaultGeckoAnimationEvent(animationFiles));
    }
}

