/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource;

import com.github.tartaricacid.simplebedrockmodel.client.manager.BedrockEntityModelRegister;
import com.github.tartaricacid.simplebedrockmodel.client.manager.BedrockEntityModelRegisterEvent;
import com.github.tartaricacid.touhoulittlemaid.client.model.BroomModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityBoxModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityFairyModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.NewEntityFairyModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class BedrockModelLoader {
    private static final Map<ResourceLocation, Function<InputStream, ? extends SimpleBedrockModel<? extends Entity>>> ALL_MODELS = Maps.newHashMap();
    public static final ResourceLocation ALTAR = BedrockModelLoader.registerSimpleBlockModel("altar");
    public static final ResourceLocation BOOKSHELF = BedrockModelLoader.registerSimpleBlockModel("bookshelf");
    public static final ResourceLocation COMPUTER = BedrockModelLoader.registerSimpleBlockModel("computer");
    public static final ResourceLocation KEYBOARD = BedrockModelLoader.registerSimpleBlockModel("keyboard");
    public static final ResourceLocation PICNIC_MAT = BedrockModelLoader.registerSimpleBlockModel("picnic_mat");
    public static final ResourceLocation PICNIC_BASKET = BedrockModelLoader.registerSimpleBlockModel("picnic_basket");
    public static final ResourceLocation STATUE_BASE = BedrockModelLoader.registerSimpleBlockModel("statue_base");
    public static final ResourceLocation SHRINE = BedrockModelLoader.registerSimpleBlockModel("shrine");
    public static final ResourceLocation GOMOKU = BedrockModelLoader.registerSimpleBlockModel("gomoku");
    public static final ResourceLocation GOMOKU_PIECE = BedrockModelLoader.registerSimpleBlockModel("gomoku_piece");
    public static final ResourceLocation CCHESS = BedrockModelLoader.registerSimpleBlockModel("cchess");
    public static final ResourceLocation CCHESS_PIECES = BedrockModelLoader.registerSimpleBlockModel("cchess_pieces");
    public static final ResourceLocation WCHESS = BedrockModelLoader.registerSimpleBlockModel("wchess");
    public static final ResourceLocation WCHESS_PIECES = BedrockModelLoader.registerSimpleBlockModel("wchess_pieces");
    public static final ResourceLocation SNACK_CABINET = BedrockModelLoader.registerSimpleBlockModel("snack_cabinet");
    public static final ResourceLocation CAKE_BOX = BedrockModelLoader.registerEntityModel("cake_box", EntityBoxModel::new);
    public static final ResourceLocation MAID_FAIRY = BedrockModelLoader.registerEntityModel("maid_fairy", EntityFairyModel::new);
    public static final ResourceLocation NEW_MAID_FAIRY = BedrockModelLoader.registerEntityModel("new_maid_fairy", NewEntityFairyModel::new);
    public static final ResourceLocation BROOM = BedrockModelLoader.registerEntityModel("broom", BroomModel::new);
    public static final ResourceLocation REIMU_YUKKURI = BedrockModelLoader.registerSimpleEntityModel("reimu_yukkuri");
    public static final ResourceLocation MARISA_YUKKURI = BedrockModelLoader.registerSimpleEntityModel("marisa_yukkuri");
    public static final ResourceLocation TOMBSTONE = BedrockModelLoader.registerSimpleEntityModel("tombstone");
    public static final ResourceLocation MAID_BANNER = BedrockModelLoader.registerSimpleEntityModel("maid_banner");
    public static final ResourceLocation BIG_BACKPACK = BedrockModelLoader.registerSimpleEntityModel("backpack/big_backpack");
    public static final ResourceLocation CRAFTING_TABLE_BACKPACK = BedrockModelLoader.registerSimpleEntityModel("backpack/crafting_table_backpack");
    public static final ResourceLocation END_CHEST_BACKPACK = BedrockModelLoader.registerSimpleEntityModel("backpack/end_chest_backpack");
    public static final ResourceLocation FURNACE_BACKPACK = BedrockModelLoader.registerSimpleEntityModel("backpack/furnace_backpack");
    public static final ResourceLocation MIDDLE_BACKPACK = BedrockModelLoader.registerSimpleEntityModel("backpack/middle_backpack");
    public static final ResourceLocation SMALL_BACKPACK = BedrockModelLoader.registerSimpleEntityModel("backpack/small_backpack");
    public static final ResourceLocation TANK_BACKPACK = BedrockModelLoader.registerSimpleEntityModel("backpack/tank_backpack");
    public static final ResourceLocation PINK_MAID_BED = BedrockModelLoader.registerSimpleBlockModel("maid_bed/pink");
    public static final ResourceLocation WHITE_MAID_BED = BedrockModelLoader.registerSimpleBlockModel("maid_bed/white");
    public static final ResourceLocation BLACK_MAID_BED = BedrockModelLoader.registerSimpleBlockModel("maid_bed/black");
    public static final ResourceLocation YELLOW_MAID_BED = BedrockModelLoader.registerSimpleBlockModel("maid_bed/yellow");
    public static final ResourceLocation BLUE_MAID_BED = BedrockModelLoader.registerSimpleBlockModel("maid_bed/blue");
    public static final ResourceLocation GREEN_MAID_BED = BedrockModelLoader.registerSimpleBlockModel("maid_bed/green");
    public static final ResourceLocation PURPLE_MAID_BED = BedrockModelLoader.registerSimpleBlockModel("maid_bed/purple");

    public static ResourceLocation registerSimpleBlockModel(String name) {
        ResourceLocation location = new ResourceLocation("touhou_little_maid", "bedrock/block/" + name);
        return BedrockModelLoader.registerSimpleModel(location);
    }

    public static ResourceLocation registerSimpleEntityModel(String name) {
        ResourceLocation location = new ResourceLocation("touhou_little_maid", "bedrock/entity/" + name);
        return BedrockModelLoader.registerSimpleModel(location);
    }

    public static ResourceLocation registerSimpleModel(ResourceLocation location) {
        return BedrockModelLoader.registerModel(location, SimpleBedrockModel::new);
    }

    public static ResourceLocation registerBlockModel(String name, Function<InputStream, ? extends SimpleBedrockModel<? extends Entity>> function) {
        ResourceLocation location = new ResourceLocation("touhou_little_maid", "bedrock/block/" + name);
        return BedrockModelLoader.registerModel(location, function);
    }

    public static ResourceLocation registerEntityModel(String name, Function<InputStream, ? extends SimpleBedrockModel<? extends Entity>> function) {
        ResourceLocation location = new ResourceLocation("touhou_little_maid", "bedrock/entity/" + name);
        return BedrockModelLoader.registerModel(location, function);
    }

    public static ResourceLocation registerModel(ResourceLocation location, Function<InputStream, ? extends SimpleBedrockModel<? extends Entity>> function) {
        ALL_MODELS.put(location, function);
        return location;
    }

    @SubscribeEvent
    public static void onRegisterBedrockModelRenderers(BedrockEntityModelRegisterEvent event) {
        ALL_MODELS.forEach(event::register);
        ALL_MODELS.clear();
    }

    @Nullable
    public static <T extends Entity> SimpleBedrockModel<T> getModel(ResourceLocation location) {
        return (SimpleBedrockModel)BedrockEntityModelRegister.INSTANCE.getModel(location);
    }
}

