/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.block.BlockSnackCabinet;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntitySnackCabinet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileEntitySnackCabinetRenderer
implements BlockEntityRenderer<TileEntitySnackCabinet> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/bedrock/block/snack_cabinet.png");
    private final SimpleBedrockModel<Entity> model = BedrockModelLoader.getModel(BedrockModelLoader.SNACK_CABINET);
    private final BedrockPart full;
    private final BedrockPart half;

    public TileEntitySnackCabinetRenderer(BlockEntityRendererProvider.Context context) {
        if (this.model == null) {
            throw new IllegalStateException("Snack Cabinet model is null!");
        }
        this.full = this.model.getPart("full");
        this.half = this.model.getPart("half");
    }

    public void render(TileEntitySnackCabinet cabinet, float partialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockState = cabinet.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)BlockSnackCabinet.FACING);
        int type = (Integer)blockState.m_61143_((Property)BlockSnackCabinet.TYPE);
        if (type == 1) {
            this.full.visible = true;
            this.half.visible = false;
        } else if (type == 2) {
            this.full.visible = false;
            this.half.visible = true;
        } else {
            this.full.visible = false;
            this.half.visible = false;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252392_.m_252977_((float)(180 - facing.m_122416_() * 90)));
        VertexConsumer consumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.model.m_7695_(poseStack, consumer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

