/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Divisor;
import it.unimi.dsi.fastutil.ints.IntIterator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

public class EntityGraphics {
    private final MultiBufferSource bufferSource;
    private final PoseStack pose;
    private final EntityMaid maid;
    private final int packedLight;
    private final float partialTicks;

    public EntityGraphics(MultiBufferSource bufferSource, PoseStack pose, EntityMaid maid, int packedLight, float partialTicks) {
        this.bufferSource = bufferSource;
        this.pose = pose;
        this.maid = maid;
        this.packedLight = packedLight;
        this.partialTicks = partialTicks;
    }

    public void fill(int minX, int minY, int maxX, int maxY, int color) {
        this.fill(minX, minY, maxX, maxY, 0, color);
    }

    public void fill(int minX, int minY, int maxX, int maxY, int z, int color) {
        this.fill(RenderType.m_269058_(), minX, minY, maxX, maxY, z, color);
    }

    public void fill(RenderType renderType, int minX, int minY, int maxX, int maxY, int color) {
        this.fill(renderType, minX, minY, maxX, maxY, 0, color);
    }

    public void fill(RenderType renderType, int minX, int minY, int maxX, int maxY, int z, int color) {
        Matrix4f matrix4f = this.pose.m_85850_().m_252922_();
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            int j = minY;
            minY = maxY;
            maxY = j;
        }
        VertexConsumer vertexconsumer = this.bufferSource.m_6299_(renderType);
        vertexconsumer.m_252986_(matrix4f, (float)minX, (float)minY, (float)z).m_193479_(color).m_85969_(this.packedLight).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)minX, (float)maxY, (float)z).m_193479_(color).m_85969_(this.packedLight).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)maxX, (float)maxY, (float)z).m_193479_(color).m_85969_(this.packedLight).m_5752_();
        vertexconsumer.m_252986_(matrix4f, (float)maxX, (float)minY, (float)z).m_193479_(color).m_85969_(this.packedLight).m_5752_();
    }

    public int drawString(Font font, FormattedCharSequence text, int x, int y, int color) {
        return this.drawString(font, text, (float)x, (float)y, color, true);
    }

    public int drawString(Font font, FormattedCharSequence text, float x, float y, int color, boolean dropShadow) {
        return font.m_272191_(text, x, y, color, dropShadow, this.pose.m_85850_().m_252922_(), this.bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public int drawString(Font font, Component text, int x, int y, int color, boolean dropShadow) {
        return this.drawString(font, text.m_7532_(), (float)x, (float)y, color, dropShadow);
    }

    public void drawWordWrap(Font font, FormattedText text, int startX, int startY, int lineWidth, int color) {
        int currentY = startY;
        for (FormattedCharSequence lineSequence : font.m_92923_(text, lineWidth)) {
            this.drawString(font, lineSequence, (float)startX, (float)currentY, color, false);
            currentY += 9;
        }
    }

    public void blitNineSliced(ResourceLocation atlasLocation, int x, int y, int width, int height, int sliceSize, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        this.blitNineSliced(atlasLocation, x, y, width, height, sliceSize, sliceSize, sliceSize, sliceSize, uOffset, vOffset, textureWidth, textureHeight);
    }

    public void blitNineSliced(ResourceLocation atlasLocation, int x, int y, int width, int height, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int textureX, int textureY) {
        this.blitNineSliced(atlasLocation, x, y, width, height, sliceWidth, sliceHeight, sliceWidth, sliceHeight, uWidth, vHeight, textureX, textureY);
    }

    public void blitNineSliced(ResourceLocation atlasLocation, int x, int y, int width, int height, int leftSliceWidth, int topSliceHeight, int rightSliceWidth, int bottomSliceHeight, int uWidth, int vHeight, int textureX, int textureY) {
        leftSliceWidth = Math.min(leftSliceWidth, width / 2);
        rightSliceWidth = Math.min(rightSliceWidth, width / 2);
        topSliceHeight = Math.min(topSliceHeight, height / 2);
        bottomSliceHeight = Math.min(bottomSliceHeight, height / 2);
        if (width == uWidth && height == vHeight) {
            this.blit(atlasLocation, x, y, textureX, textureY, width, height);
        } else if (height == vHeight) {
            this.blit(atlasLocation, x, y, textureX, textureY, leftSliceWidth, height);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, height, textureX + leftSliceWidth, textureY, uWidth - rightSliceWidth - leftSliceWidth, vHeight);
            this.blit(atlasLocation, x + width - rightSliceWidth, y, textureX + uWidth - rightSliceWidth, textureY, rightSliceWidth, height);
        } else if (width == uWidth) {
            this.blit(atlasLocation, x, y, textureX, textureY, width, topSliceHeight);
            this.blitRepeating(atlasLocation, x, y + topSliceHeight, width, height - bottomSliceHeight - topSliceHeight, textureX, textureY + topSliceHeight, uWidth, vHeight - bottomSliceHeight - topSliceHeight);
            this.blit(atlasLocation, x, y + height - bottomSliceHeight, textureX, textureY + vHeight - bottomSliceHeight, width, bottomSliceHeight);
        } else {
            this.blit(atlasLocation, x, y, textureX, textureY, leftSliceWidth, topSliceHeight);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, topSliceHeight, textureX + leftSliceWidth, textureY, uWidth - rightSliceWidth - leftSliceWidth, topSliceHeight);
            this.blit(atlasLocation, x + width - rightSliceWidth, y, textureX + uWidth - rightSliceWidth, textureY, rightSliceWidth, topSliceHeight);
            this.blit(atlasLocation, x, y + height - bottomSliceHeight, textureX, textureY + vHeight - bottomSliceHeight, leftSliceWidth, bottomSliceHeight);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y + height - bottomSliceHeight, width - rightSliceWidth - leftSliceWidth, bottomSliceHeight, textureX + leftSliceWidth, textureY + vHeight - bottomSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, bottomSliceHeight);
            this.blit(atlasLocation, x + width - rightSliceWidth, y + height - bottomSliceHeight, textureX + uWidth - rightSliceWidth, textureY + vHeight - bottomSliceHeight, rightSliceWidth, bottomSliceHeight);
            this.blitRepeating(atlasLocation, x, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX, textureY + topSliceHeight, leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y + topSliceHeight, width - rightSliceWidth - leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX + leftSliceWidth, textureY + topSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight);
            this.blitRepeating(atlasLocation, x + width - rightSliceWidth, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX + uWidth - rightSliceWidth, textureY + topSliceHeight, rightSliceWidth, vHeight - bottomSliceHeight - topSliceHeight);
        }
    }

    public void blitRepeating(ResourceLocation atlas, int startX, int startY, int areaWidth, int areaHeight, int uOffset, int vOffset, int sourceWidth, int sourceHeight) {
        this.blitRepeating(atlas, startX, startY, areaWidth, areaHeight, uOffset, vOffset, sourceWidth, sourceHeight, 256, 256);
    }

    public void blitRepeating(ResourceLocation atlas, int startX, int startY, int areaWidth, int areaHeight, int uOffset, int vOffset, int sourceWidth, int sourceHeight, int textureWidth, int textureHeight) {
        int currentX = startX;
        IntIterator widthIterator = EntityGraphics.slices(areaWidth, sourceWidth);
        while (widthIterator.hasNext()) {
            int sliceWidth = widthIterator.nextInt();
            int uPadding = (sourceWidth - sliceWidth) / 2;
            int currentY = startY;
            IntIterator heightIterator = EntityGraphics.slices(areaHeight, sourceHeight);
            while (heightIterator.hasNext()) {
                int sliceHeight = heightIterator.nextInt();
                int vPadding = (sourceHeight - sliceHeight) / 2;
                this.blit(atlas, currentX, currentY, uOffset + uPadding, vOffset + vPadding, sliceWidth, sliceHeight, textureWidth, textureHeight);
                currentY += sliceHeight;
            }
            currentX += sliceWidth;
        }
    }

    private static IntIterator slices(int totalLength, int sliceLength) {
        int count = Mth.m_184652_((int)totalLength, (int)sliceLength);
        return new Divisor(totalLength, count);
    }

    public void blit(ResourceLocation atlasLocation, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        this.blit(atlasLocation, x, y, 0, uOffset, vOffset, uWidth, vHeight, 256, 256);
    }

    public void blit(ResourceLocation atlasLocation, int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, x + uWidth, y, y + vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public void blit(ResourceLocation atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    public void blit(ResourceLocation atlasLocation, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    void blit(ResourceLocation atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        this.innerBlit(atlasLocation, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight);
    }

    public void innerBlit(ResourceLocation atlas, int x1, int x2, int y1, int y2, int z, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlas);
        RenderSystem.setShader(GameRenderer::m_172835_);
        Matrix4f matrix4f = this.pose.m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
        bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y1, (float)z).m_193479_(-1).m_7421_(minU, minV).m_85969_(this.packedLight).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x1, (float)y2, (float)z).m_193479_(-1).m_7421_(minU, maxV).m_85969_(this.packedLight).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y2, (float)z).m_193479_(-1).m_7421_(maxU, maxV).m_85969_(this.packedLight).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)x2, (float)y1, (float)z).m_193479_(-1).m_7421_(maxU, minV).m_85969_(this.packedLight).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    public int getPackedLight() {
        return this.packedLight;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public PoseStack getPoseStack() {
        return this.pose;
    }

    @ApiStatus.AvailableSince(value="1.4.7")
    public MultiBufferSource getBufferSource() {
        return this.bufferSource;
    }

    @ApiStatus.AvailableSince(value="1.4.7")
    public PoseStack getPose() {
        return this.pose;
    }
}

