/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.overlay;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.ModKubeJSCompat;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.RenderConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class MaidTipsOverlay
implements IGuiOverlay {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_tips_icon.png");
    private static Map<Item, MutableComponent> TIPS = Maps.newHashMap();
    private static Map<Item, ForgeConfigSpec.BooleanValue> TIPS_CONFIG = Maps.newHashMap();
    private static Map<CheckCondition, MutableComponent> SPECIAL_TIPS = Maps.newHashMap();

    public MaidTipsOverlay() {
        TIPS = Maps.newHashMap();
        TIPS_CONFIG = Maps.newHashMap();
        SPECIAL_TIPS = Maps.newHashMap();
    }

    public static void init() {
        MaidTipsOverlay overlay = new MaidTipsOverlay();
        overlay.addTips("overlay.touhou_little_maid.compass.tips", RenderConfig.ENABLE_COMPASS_TIP, Items.f_42522_);
        overlay.addTips("overlay.touhou_little_maid.golden_apple.tips", RenderConfig.ENABLE_GOLDEN_APPLE_TIP, Items.f_42436_, Items.f_42437_);
        overlay.addTips("overlay.touhou_little_maid.potion.tips", RenderConfig.ENABLE_POTION_TIP, Items.f_42589_);
        overlay.addTips("overlay.touhou_little_maid.milk_bucket.tips", RenderConfig.ENABLE_MILK_BUCKET_TIP, Items.f_42455_);
        overlay.addTips("overlay.touhou_little_maid.glass_bottle.tips", RenderConfig.ENABLE_GLASS_BOTTLE_TIP, Items.f_42590_);
        overlay.addTips("overlay.touhou_little_maid.name_tag.tips", RenderConfig.ENABLE_NAME_TAG_TIP, Items.f_42656_);
        overlay.addTips("overlay.touhou_little_maid.lead.tips", RenderConfig.ENABLE_LEAD_TIP, Items.f_42655_);
        overlay.addTips("overlay.touhou_little_maid.debug_stick.tips", Items.f_42751_);
        overlay.addTips("overlay.touhou_little_maid.saddle.tips", RenderConfig.ENABLE_SADDLE_TIP, Items.f_42450_);
        overlay.addSpecialTips("overlay.touhou_little_maid.ntr_item.tips", (item, maid, player) -> !maid.m_21830_((LivingEntity)player) && EntityMaid.getNtrItem().test(item));
        overlay.addSpecialTips("overlay.touhou_little_maid.remove_backpack.tips", MaidTipsOverlay::checkShears);
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.addMaidTips(overlay);
        }
        ModKubeJSCompat.maidTipsOverlayInit(overlay);
        TIPS = ImmutableMap.copyOf(TIPS);
        TIPS_CONFIG = ImmutableMap.copyOf(TIPS_CONFIG);
        SPECIAL_TIPS = ImmutableMap.copyOf(SPECIAL_TIPS);
    }

    private static boolean checkShears(ItemStack item, EntityMaid maid, LocalPlayer player) {
        if (!((Boolean)RenderConfig.ENABLE_SHEARS_TIP.get()).booleanValue()) {
            return false;
        }
        return maid.m_21830_((LivingEntity)player) && maid.hasBackpack() && item.m_204117_(Tags.Items.SHEARS);
    }

    private static MutableComponent checkSpecialTips(ItemStack mainhandItem, EntityMaid maid, LocalPlayer player) {
        for (Map.Entry<CheckCondition, MutableComponent> entry : SPECIAL_TIPS.entrySet()) {
            CheckCondition condition = entry.getKey();
            MutableComponent text = entry.getValue();
            if (!condition.test(mainhandItem, maid, player)) continue;
            return text;
        }
        return null;
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        MutableComponent tip;
        Minecraft minecraft = gui.getMinecraft();
        Options options = minecraft.f_91066_;
        if (!options.m_92176_().m_90612_()) {
            return;
        }
        if (minecraft.f_91072_ == null || minecraft.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        HitResult hitResult = minecraft.f_91077_;
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult result = (EntityHitResult)hitResult;
        Entity entity = result.m_82443_();
        if (!(entity instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)entity;
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (!maid.m_6084_()) {
            return;
        }
        if (player.m_20202_() != null && player.m_20202_().equals((Object)maid.m_20202_())) {
            return;
        }
        ItemStack itemStack = player.m_21205_();
        Item item = itemStack.m_41720_();
        if (maid.m_21830_((LivingEntity)player) && TIPS.containsKey(item)) {
            boolean configIsEnable;
            boolean configIsNull = !TIPS_CONFIG.containsKey(item);
            boolean bl = configIsEnable = TIPS_CONFIG.containsKey(item) && (Boolean)TIPS_CONFIG.get(item).get() != false;
            tip = configIsNull || configIsEnable ? TIPS.get(item) : MaidTipsOverlay.checkSpecialTips(itemStack, maid, player);
        } else {
            tip = MaidTipsOverlay.checkSpecialTips(itemStack, maid, player);
        }
        if (tip != null) {
            gui.setupOverlayRenderState(true, false);
            List split = minecraft.f_91062_.m_92923_((FormattedText)tip, 120);
            int offset = screenHeight / 2 - 5 - split.size() * 10;
            guiGraphics.m_280480_(itemStack, screenWidth / 2 + 32, offset);
            guiGraphics.m_280163_(ICON, screenWidth / 2 + 42, offset - 4, 16.0f, 16.0f, 16, 16, 16, 16);
            offset += 18;
            for (FormattedCharSequence sequence : split) {
                guiGraphics.m_280648_(minecraft.f_91062_, sequence, screenWidth / 2 + 32, offset, 0xFFFFFF);
                offset += 10;
            }
        }
    }

    public void addTips(String key, Item ... items) {
        this.addTips(key, (ForgeConfigSpec.BooleanValue)null, items);
    }

    public void addTips(String key, @Nullable ForgeConfigSpec.BooleanValue config, Item ... items) {
        for (Item item : items) {
            TIPS.put(item, Component.m_237115_((String)key));
            if (config == null) continue;
            TIPS_CONFIG.put(item, config);
        }
    }

    public void addSpecialTips(String key, CheckCondition condition) {
        SPECIAL_TIPS.put(condition, Component.m_237115_((String)key));
    }

    public static interface CheckCondition {
        public boolean test(ItemStack var1, EntityMaid var2, LocalPlayer var3);
    }
}

