/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack.IBackpackContainerScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.BaubleButton;
import com.github.tartaricacid.touhoulittlemaid.compat.curios.CuriosCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.TankBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.util.MaidFluidRender;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class TankBackpackContainerScreen
extends AbstractMaidContainerGui<TankBackpackContainer>
implements IBackpackContainerScreen {
    private static final ResourceLocation BACKPACK = new ResourceLocation("touhou_little_maid", "textures/gui/maid_tank.png");
    private final EntityMaid maid;

    public TankBackpackContainerScreen(TankBackpackContainer container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn);
        this.f_97727_ = 256;
        this.f_97726_ = 256;
        this.maid = ((TankBackpackContainer)this.f_97732_).getMaid();
    }

    @Override
    protected void initAdditionWidgets() {
        BaubleButton button = this.getBaubleButton(this.maid, this.f_97735_, this.f_97736_);
        this.m_142416_((GuiEventListener)button);
        if (CuriosCompat.isLoadedOrEnable()) {
            this.m_142416_((GuiEventListener)this.getCuriosButton(this.maid, this.f_97735_, this.f_97736_));
        }
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        boolean yInRange;
        super.m_7286_(graphics, partialTicks, x, y);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKPACK);
        graphics.m_280218_(BACKPACK, this.f_97735_ + 85, this.f_97736_ + 36, 0, 0, 165, 128);
        RenderSystem.enableBlend();
        MaidFluidRender.drawFluid(graphics, this.f_97735_ + 200, this.f_97736_ + 108, 29, 50, this.maid.getBackpackFluid(), ((TankBackpackContainer)this.f_97732_).getFluidCount(), 10000);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        graphics.m_280218_(BACKPACK, this.f_97735_ + 197, this.f_97736_ + 104, 165, 0, 34, 50);
        boolean xInRange = this.f_97735_ + 196 <= x && x <= this.f_97735_ + 196 + 29;
        boolean bl = yInRange = this.f_97736_ + 108 <= y && y <= this.f_97736_ + 108 + 50;
        if (xInRange && yInRange) {
            MutableComponent fluidInfo = Component.m_237110_((String)"tooltips.touhou_little_maid.tank_backpack.fluid", (Object[])new Object[]{MaidFluidRender.getFluidName(this.maid.getBackpackFluid(), ((TankBackpackContainer)this.f_97732_).getFluidCount()), ((TankBackpackContainer)this.f_97732_).getFluidCount()}).m_130940_(ChatFormatting.GRAY);
            MutableComponent capacityInfo = Component.m_237110_((String)"tooltips.touhou_little_maid.tank_backpack.capacity", (Object[])new Object[]{10000}).m_130940_(ChatFormatting.GRAY);
            graphics.m_280666_(this.f_96547_, (List)Lists.newArrayList((Object[])new Component[]{fluidInfo, capacityInfo}), x, y);
        }
    }
}

